/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class ConnectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionUtils.class);

    private ConnectionUtils() {
    }

    static List<List<String>> splitFieldList(List<String> fieldNames, int maxSize) {
        ArrayList<List<String>> chunks = new ArrayList<List<String>>();
        String separator = ",";
        ArrayList<String> chunk = new ArrayList<String>();
        for (String fName : fieldNames) {
            if (fName.length() > maxSize) {
                logger.warn("Field name <{}> by itself was bigger than the chunk size; adding it as its own chunk", (Object)fName);
                chunks.add(Arrays.asList(fName));
                continue;
            }
            if (chunk.isEmpty()) {
                chunk.add(fName);
                continue;
            }
            if (ConnectionUtils.getChunkLength(chunk) + fName.length() + separator.length() <= maxSize) {
                chunk.add(fName);
                continue;
            }
            chunks.add(chunk);
            chunk = new ArrayList();
            chunk.add(fName);
        }
        if (!chunk.isEmpty()) {
            chunks.add(chunk);
        }
        return chunks;
    }

    private static int getChunkLength(List<String> chunk) {
        if (chunk.isEmpty()) {
            return 0;
        }
        int fieldNameSum = 0;
        for (String s : chunk) {
            fieldNameSum += s.length();
        }
        int numCommas = chunk.size() - 1;
        return fieldNameSum + numCommas;
    }
}

