/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.soap.DescribeGlobalResult;
import com.palominolabs.crm.sf.soap.GlobalSObjectDescription;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DescribeGlobalResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DescribeGlobalSObjectResultType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class DescribeGlobalResultImpl
implements DescribeGlobalResult {
    @Nullable
    private final String encoding;
    private final int maxBatchSize;
    private final List<GlobalSObjectDescription> types;

    DescribeGlobalResultImpl(DescribeGlobalResultType stubResult) {
        this.encoding = stubResult.getEncoding();
        this.maxBatchSize = stubResult.getMaxBatchSize();
        ArrayList<GlobalSObjectDescription> mutableList = new ArrayList<GlobalSObjectDescription>();
        for (DescribeGlobalSObjectResultType stubDesc : stubResult.getSobjects()) {
            mutableList.add(new GlobalSObjectDescription(stubDesc));
        }
        this.types = Collections.unmodifiableList(new ArrayList(mutableList));
    }

    @Override
    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    @Nonnull
    public List<GlobalSObjectDescription> getSObjectTypes() {
        return this.types;
    }

    @Override
    @Nonnull
    public Set<String> getSObjectNames() {
        HashSet<String> names = new HashSet<String>();
        for (GlobalSObjectDescription desc : this.types) {
            names.add(desc.getName());
        }
        return Collections.unmodifiableSet(names);
    }
}

