/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.soap.ApiUtils;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.ManageableState;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public final class FileProperties {
    private final com.palominolabs.crm.sf.soap.jaxwsstub.metadata.FileProperties stub;

    public FileProperties(@Nonnull com.palominolabs.crm.sf.soap.jaxwsstub.metadata.FileProperties stub) {
        this.stub = stub;
    }

    @Nonnull
    public Id getCreatedById() {
        return new Id(this.stub.getCreatedById());
    }

    @Nonnull
    public String getCreatedByName() {
        return this.stub.getCreatedByName();
    }

    @Nonnull
    public DateTime getCreatedDate() {
        return ApiUtils.convertSFTimeToDateTime(this.stub.getCreatedDate());
    }

    @Nonnull
    public String getFileName() {
        return this.stub.getFileName();
    }

    @Nonnull
    public String getFullName() {
        return this.stub.getFullName();
    }

    @Nullable
    public Id getId() {
        String stubId = this.stub.getId();
        if (stubId != null && !stubId.isEmpty()) {
            return new Id(stubId);
        }
        return null;
    }

    @Nonnull
    public Id getLastModifiedById() {
        return new Id(this.stub.getLastModifiedById());
    }

    @Nonnull
    public String getLastModifiedByName() {
        return this.stub.getLastModifiedByName();
    }

    @Nonnull
    public DateTime getLastModifiedDate() {
        return ApiUtils.convertSFTimeToDateTime(this.stub.getLastModifiedDate());
    }

    @Nullable
    public ManageableState getManageableState() {
        return this.stub.getManageableState();
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.stub.getNamespacePrefix();
    }

    @Nonnull
    public String getType() {
        return this.stub.getType();
    }

    public String toString() {
        return "FileProperties{createdById=" + this.getCreatedById() + ", createdByName='" + this.getCreatedByName() + '\'' + ", createdDate=" + this.getCreatedDate() + ", fileName='" + this.getFileName() + '\'' + ", fullName='" + this.getFullName() + '\'' + ", id=" + this.getId() + ", lastModifiedById=" + this.getLastModifiedById() + ", lastModifiedByName='" + this.getLastModifiedByName() + '\'' + ", lastModifiedDate=" + this.getLastModifiedDate() + ", manageableState=" + this.getManageableState() + ", namespacePrefix='" + this.getNamespacePrefix() + '\'' + ", type='" + this.getType() + '\'' + '}';
    }
}

