/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.soap.AbstractSalesforceConnection;
import com.palominolabs.crm.sf.soap.ApiException;
import com.palominolabs.crm.sf.soap.AsyncResult;
import com.palominolabs.crm.sf.soap.CallSemaphore;
import com.palominolabs.crm.sf.soap.ConfiguredBinding;
import com.palominolabs.crm.sf.soap.ConnectionBundleImpl;
import com.palominolabs.crm.sf.soap.FileProperties;
import com.palominolabs.crm.sf.soap.ListMetadataQuery;
import com.palominolabs.crm.sf.soap.MetadataConnection;
import com.palominolabs.crm.sf.soap.WaitForAsyncResult;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.DescribeMetadataResult;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.Metadata;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.MetadataPortType;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.RetrieveRequest;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.RetrieveResult;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.UpdateMetadata;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.ws.WebServiceException;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

@ThreadSafe
final class MetadataConnectionImpl
extends AbstractSalesforceConnection
implements MetadataConnection {
    private final MetricRegistry metricRegistry;

    MetadataConnectionImpl(@Nonnull CallSemaphore semaphore, @Nonnull ConnectionBundleImpl bundle, MetricRegistry metricRegistry) {
        super(semaphore, bundle);
        this.metricRegistry = metricRegistry;
    }

    @Override
    @Nonnull
    public WaitForAsyncResult waitForAsyncResults(@Nonnull List<AsyncResult> results, long maxMillisToWait) throws ApiException, InterruptedException {
        DateTime startTime = new DateTime();
        long millisWaited = 0L;
        long nextWait = 1000L;
        List<AsyncResult> latestAsyncResults = results;
        boolean maxTimeHit = false;
        while (true) {
            ArrayList<Id> idsToCheck = new ArrayList<Id>();
            for (AsyncResult result : latestAsyncResults) {
                if (result.isDone()) continue;
                idsToCheck.add(result.getId());
            }
            if (idsToCheck.isEmpty() || maxTimeHit) {
                DateTime endTime = new DateTime();
                Duration elapsed = new Duration((ReadableInstant)startTime, (ReadableInstant)endTime);
                return new WaitForAsyncResult(elapsed, latestAsyncResults);
            }
            latestAsyncResults = this.checkStatus(idsToCheck);
            if (millisWaited >= maxMillisToWait) {
                maxTimeHit = true;
                continue;
            }
            Thread.sleep(nextWait);
            if ((millisWaited += nextWait) + (nextWait *= 2L) <= maxMillisToWait) continue;
            nextWait = maxMillisToWait - millisWaited;
        }
    }

    @Override
    @Nonnull
    public synchronized List<AsyncResult> checkStatus(@Nonnull List<Id> idsToCheck) throws ApiException {
        ArrayList<String> idStrList = new ArrayList<String>();
        for (Id id : idsToCheck) {
            idStrList.add(id.toString());
        }
        return MetadataConnectionImpl.convertStubAsyncResultList((List)new CheckStatusOp().execute(idStrList));
    }

    @Override
    @Nonnull
    public synchronized List<AsyncResult> create(@Nonnull List<Metadata> metadataList) throws ApiException {
        return MetadataConnectionImpl.convertStubAsyncResultList((List)new CreateOp().execute(metadataList));
    }

    @Override
    @Nonnull
    public synchronized List<AsyncResult> delete(@Nonnull List<Metadata> metadataList) throws ApiException {
        return MetadataConnectionImpl.convertStubAsyncResultList((List)new DeleteOp().execute(metadataList));
    }

    @Override
    @Nonnull
    public synchronized List<AsyncResult> update(@Nonnull List<UpdateMetadata> metadataList) throws ApiException {
        return MetadataConnectionImpl.convertStubAsyncResultList((List)new UpdateOp().execute(metadataList));
    }

    @Override
    @Nonnull
    public synchronized List<FileProperties> listMetadata(@Nonnull List<ListMetadataQuery> queries) throws ApiException {
        ArrayList<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.ListMetadataQuery> stubList = new ArrayList<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.ListMetadataQuery>();
        for (ListMetadataQuery query : queries) {
            stubList.add(query.getStubObject());
        }
        List stubResultList = (List)new ListMetadataOp().execute(stubList);
        ArrayList<FileProperties> resultList = new ArrayList<FileProperties>(stubResultList.size());
        for (com.palominolabs.crm.sf.soap.jaxwsstub.metadata.FileProperties stub : stubResultList) {
            resultList.add(new FileProperties(stub));
        }
        return resultList;
    }

    @Override
    @Nonnull
    public synchronized AsyncResult retrieve(@Nonnull com.palominolabs.crm.sf.soap.RetrieveRequest retrieveRequest) throws ApiException {
        return new AsyncResult((com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult)new RetrieveOp().execute(retrieveRequest.getStub()));
    }

    @Override
    @Nonnull
    public synchronized com.palominolabs.crm.sf.soap.RetrieveResult getRetrieveResult(@Nonnull Id id) throws ApiException {
        return new com.palominolabs.crm.sf.soap.RetrieveResult((RetrieveResult)new CheckRetrieveStatusOp().execute(id.toString()));
    }

    @Override
    @Nonnull
    public synchronized com.palominolabs.crm.sf.soap.DescribeMetadataResult describeMetadata() throws ApiException {
        return this.describeMetadata(28.0);
    }

    @Override
    @Nonnull
    public synchronized com.palominolabs.crm.sf.soap.DescribeMetadataResult describeMetadata(double apiVersion) throws ApiException {
        DescribeMetadataResult describeMetadataResult = (DescribeMetadataResult)new DescribeMetadataOp().execute(apiVersion);
        return new com.palominolabs.crm.sf.soap.DescribeMetadataResult(describeMetadataResult);
    }

    @Nonnull
    private static List<AsyncResult> convertStubAsyncResultList(@Nonnull List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult> stubAsyncResults) {
        ArrayList<AsyncResult> results = new ArrayList<AsyncResult>();
        for (com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult stubAsyncResult : stubAsyncResults) {
            results.add(new AsyncResult(stubAsyncResult));
        }
        return results;
    }

    private class DescribeMetadataOp
    extends MetadataApiOperation<Double, DescribeMetadataResult> {
        private DescribeMetadataOp() {
        }

        @Override
        @Nonnull
        DescribeMetadataResult executeOp(@Nonnull MetadataPortType binding, @Nonnull Double param) {
            return binding.describeMetadata(param.doubleValue());
        }
    }

    private class CheckRetrieveStatusOp
    extends MetadataApiOperation<String, RetrieveResult> {
        private CheckRetrieveStatusOp() {
        }

        @Override
        @Nonnull
        RetrieveResult executeOp(@Nonnull MetadataPortType binding, @Nonnull String param) {
            return binding.checkRetrieveStatus(param);
        }
    }

    private class RetrieveOp
    extends MetadataApiOperation<RetrieveRequest, com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult> {
        private RetrieveOp() {
        }

        @Override
        @Nonnull
        com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult executeOp(@Nonnull MetadataPortType binding, @Nonnull RetrieveRequest param) {
            return binding.retrieve(param);
        }
    }

    private class ListMetadataOp
    extends MetadataApiOperation<List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.ListMetadataQuery>, List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.FileProperties>> {
        private ListMetadataOp() {
        }

        @Override
        @Nonnull
        List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.FileProperties> executeOp(@Nonnull MetadataPortType binding, @Nonnull List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.ListMetadataQuery> param) {
            return binding.listMetadata(param, 28.0);
        }
    }

    private class UpdateOp
    extends MetadataApiOperation<List<UpdateMetadata>, List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult>> {
        private UpdateOp() {
        }

        @Override
        @Nonnull
        List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult> executeOp(@Nonnull MetadataPortType binding, @Nonnull List<UpdateMetadata> param) {
            return binding.update(param);
        }
    }

    private class DeleteOp
    extends MetadataApiOperation<List<Metadata>, List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult>> {
        private DeleteOp() {
        }

        @Override
        @Nonnull
        List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult> executeOp(@Nonnull MetadataPortType binding, @Nonnull List<Metadata> param) {
            return binding.delete(param);
        }
    }

    private class CreateOp
    extends MetadataApiOperation<List<Metadata>, List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult>> {
        private CreateOp() {
        }

        @Override
        @Nonnull
        List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult> executeOp(@Nonnull MetadataPortType binding, @Nonnull List<Metadata> param) {
            return binding.create(param);
        }
    }

    private class CheckStatusOp
    extends MetadataApiOperation<List<String>, List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult>> {
        private CheckStatusOp() {
        }

        @Override
        @Nonnull
        List<com.palominolabs.crm.sf.soap.jaxwsstub.metadata.AsyncResult> executeOp(@Nonnull MetadataPortType binding, @Nonnull List<String> param) {
            return binding.checkStatus(param);
        }
    }

    private abstract class MetadataApiOperation<Tin, Tout>
    extends AbstractSalesforceConnection.ApiOperation<Tin, Tout, MetadataPortType> {
        private final Timer timer;

        private MetadataApiOperation() {
            this.timer = MetadataConnectionImpl.this.metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"request"}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        final Tout executeImpl(@Nonnull ConfiguredBinding<MetadataPortType> binding, @Nonnull Tin param) throws ApiException {
            Timer.Context context = this.timer.time();
            try {
                Tout Tout;
                MetadataConnectionImpl.this.acquireSemaphore();
                try {
                    Tout = this.executeOp(binding.getBinding(), param);
                }
                catch (Throwable throwable) {
                    try {
                        MetadataConnectionImpl.this.releaseSemaphore();
                        throw throwable;
                    }
                    catch (WebServiceException e) {
                        throw MetadataConnectionImpl.this.getApiExceptionWithCause("Call failed", e);
                    }
                }
                MetadataConnectionImpl.this.releaseSemaphore();
                return Tout;
            }
            finally {
                context.stop();
            }
        }

        @Nonnull
        abstract Tout executeOp(@Nonnull MetadataPortType var1, @Nonnull Tin var2);

        @Override
        void releaseBinding(@Nonnull MetadataPortType binding) {
            MetadataConnectionImpl.this.connBundle.acceptReleasedMetadataBinding(binding);
        }

        @Override
        @Nonnull
        ConfiguredBinding<MetadataPortType> getBinding() throws ApiException {
            return MetadataConnectionImpl.this.connBundle.getMetadataBinding();
        }
    }
}

