/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.soap.PartnerApiError;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.ErrorType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.StatusCodeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
final class PartnerApiErrorImpl
implements PartnerApiError {
    private final StatusCodeType statusCode;
    private final String message;
    private final List<String> fields;

    PartnerApiErrorImpl(ErrorType stubError) {
        if (stubError.getMessage() == null) {
            throw new NullPointerException("message cannot be null");
        }
        if (stubError.getStatusCode() == null) {
            throw new NullPointerException("status code cannot be null");
        }
        this.statusCode = stubError.getStatusCode();
        this.message = stubError.getMessage();
        this.fields = Collections.unmodifiableList(new ArrayList(stubError.getFields()));
    }

    @Override
    public StatusCodeType getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{statusCode: ");
        builder.append(this.getStatusCode());
        builder.append(", message: ");
        builder.append(this.getMessage());
        builder.append(", fields: ");
        builder.append(this.getFields().toString());
        builder.append("}");
        return builder.toString();
    }
}

