/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.soap.AbstractSalesforceConnection;
import com.palominolabs.crm.sf.soap.ApiException;
import com.palominolabs.crm.sf.soap.ApiUtils;
import com.palominolabs.crm.sf.soap.CallSemaphore;
import com.palominolabs.crm.sf.soap.ConfiguredBinding;
import com.palominolabs.crm.sf.soap.ConnectionBundleImpl;
import com.palominolabs.crm.sf.soap.ConnectionUtils;
import com.palominolabs.crm.sf.soap.DeleteResult;
import com.palominolabs.crm.sf.soap.DescribeGlobalResult;
import com.palominolabs.crm.sf.soap.DescribeGlobalResultImpl;
import com.palominolabs.crm.sf.soap.EmptyRecycleBinResult;
import com.palominolabs.crm.sf.soap.PartnerConnection;
import com.palominolabs.crm.sf.soap.PartnerQueryLocator;
import com.palominolabs.crm.sf.soap.PartnerQueryResult;
import com.palominolabs.crm.sf.soap.PartnerQueryResultImpl;
import com.palominolabs.crm.sf.soap.PartnerSObject;
import com.palominolabs.crm.sf.soap.PartnerSObjectImpl;
import com.palominolabs.crm.sf.soap.SObjectConversionException;
import com.palominolabs.crm.sf.soap.SObjectDescription;
import com.palominolabs.crm.sf.soap.SObjects;
import com.palominolabs.crm.sf.soap.SaveResult;
import com.palominolabs.crm.sf.soap.SaveResultImpl;
import com.palominolabs.crm.sf.soap.UndeleteResult;
import com.palominolabs.crm.sf.soap.UpsertResult;
import com.palominolabs.crm.sf.soap.UserInfo;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.ApiFault;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.ApiQueryFault;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Create;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.CreateResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Delete;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DeleteResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DeleteResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DescribeGlobal;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DescribeGlobalResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DescribeGlobalResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DescribeSObjectResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DescribeSObjects;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.DescribeSObjectsResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.EmptyRecycleBin;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.EmptyRecycleBinResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.EmptyRecycleBinResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.ExceptionCode;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.GetServerTimestamp;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.GetServerTimestampResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.GetServerTimestampResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.GetUserInfo;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.GetUserInfoResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.InvalidFieldFault_Exception;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.InvalidIdFault_Exception;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.InvalidQueryLocatorFault_Exception;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.InvalidSObjectFault_Exception;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Logout;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.LogoutResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.MalformedQueryFault_Exception;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Query;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.QueryAll;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.QueryAllResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.QueryMore;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.QueryMoreResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.QueryResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.QueryResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Retrieve;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.RetrieveResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.SObject;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.SaveResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Soap;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Undelete;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.UndeleteResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.UndeleteResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.UnexpectedErrorFault_Exception;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Update;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.UpdateResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Upsert;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.UpsertResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.UpsertResultType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@ThreadSafe
final class PartnerConnectionImpl
extends AbstractSalesforceConnection
implements PartnerConnection {
    private static final XLogger logger = XLoggerFactory.getXLogger(PartnerConnectionImpl.class);
    private final MetricRegistry metricRegistry;

    private PartnerConnectionImpl(@Nonnull CallSemaphore semaphore, @Nonnull ConnectionBundleImpl bundle, MetricRegistry metricRegistry) {
        super(semaphore, bundle);
        this.metricRegistry = metricRegistry;
    }

    @Nonnull
    static PartnerConnectionImpl getNew(@Nonnull CallSemaphore semaphore, @Nonnull ConnectionBundleImpl bundle, MetricRegistry metricRegistry) {
        return new PartnerConnectionImpl(semaphore, bundle, metricRegistry);
    }

    @Override
    public synchronized int count(@Nonnull String sObjectType, @Nonnull String condition) throws ApiException {
        String queryStr = "SELECT count() FROM " + sObjectType + " WHERE " + condition;
        QueryResultType qResultStub = this.queryImpl(queryStr);
        return qResultStub.getSize();
    }

    @Override
    public synchronized int count(@Nonnull String sObjectType) throws ApiException {
        String queryStr = "SELECT count() FROM " + sObjectType;
        QueryResultType qResultStub = this.queryImpl(queryStr);
        return qResultStub.getSize();
    }

    @Override
    public synchronized int countAll(@Nonnull String sObjectType, @Nonnull String condition) throws ApiException {
        logger.entry(new Object[]{sObjectType, condition});
        String queryStr = "SELECT count() FROM " + sObjectType + " WHERE " + condition;
        QueryResultType qResultStub = this.queryAllImpl(queryStr);
        int size = qResultStub.getSize();
        logger.exit((Object)size);
        return size;
    }

    @Override
    public synchronized int countAll(@Nonnull String sObjectType) throws ApiException {
        logger.entry(new Object[]{sObjectType});
        String queryStr = "SELECT count() FROM " + sObjectType;
        QueryResultType qResultStub = this.queryAllImpl(queryStr);
        int size = qResultStub.getSize();
        logger.exit((Object)size);
        return size;
    }

    @Override
    @Nonnull
    public synchronized List<SaveResult> create(@Nonnull List<com.palominolabs.crm.sf.core.SObject> sObjects) throws ApiException {
        logger.entry(new Object[]{sObjects});
        Create createParam = new Create();
        List stubSObjects = createParam.getSObjects();
        this.writeSObjectsToStubSObjectList(sObjects, stubSObjects);
        CreateOp op = new CreateOp();
        CreateResponse response = (CreateResponse)op.execute(createParam);
        List stubResults = response.getResult();
        ArrayList<SaveResult> results = new ArrayList<SaveResult>();
        for (SaveResultType stubResult : stubResults) {
            results.add(new SaveResultImpl(stubResult));
        }
        logger.exit(results);
        return results;
    }

    @Override
    @Nonnull
    public synchronized List<DeleteResult> delete(@Nonnull List<Id> ids) throws ApiException {
        logger.entry(new Object[]{ids});
        Delete deleteParam = new Delete();
        for (Id id : ids) {
            deleteParam.getIds().add(id.toString());
        }
        DeleteOp op = new DeleteOp();
        DeleteResponse response = (DeleteResponse)op.execute(deleteParam);
        ArrayList<DeleteResult> results = new ArrayList<DeleteResult>();
        for (DeleteResultType stubResult : response.getResult()) {
            results.add(new DeleteResult(stubResult));
        }
        logger.exit(results);
        return results;
    }

    @Override
    @Nonnull
    public synchronized DescribeGlobalResult describeGlobal() throws ApiException {
        logger.entry(new Object[0]);
        DescribeGlobal descrParam = new DescribeGlobal();
        DescribeGlobalOp op = new DescribeGlobalOp();
        DescribeGlobalResponse response = (DescribeGlobalResponse)op.execute(descrParam);
        DescribeGlobalResultType stubResult = response.getResult();
        DescribeGlobalResultImpl result = new DescribeGlobalResultImpl(stubResult);
        logger.exit((Object)result);
        return result;
    }

    @Override
    @Nonnull
    public synchronized SObjectDescription describeSObject(@Nonnull String sObjectType) throws ApiException {
        ArrayList<String> sObjTypes = new ArrayList<String>();
        sObjTypes.add(sObjectType);
        List<SObjectDescription> results = this.describeSObjects(sObjTypes);
        if (results.size() != 1) {
            throw ApiException.getNew("Got back " + results.size() + " results instead of exactly 1", this.getUsername());
        }
        return results.get(0);
    }

    @Override
    @Nonnull
    public synchronized List<SObjectDescription> describeSObjects(@Nonnull List<String> sObjectTypes) throws ApiException {
        logger.entry(new Object[]{sObjectTypes});
        DescribeSObjects descrParam = new DescribeSObjects();
        descrParam.getSObjectType().addAll(sObjectTypes);
        DescribeSObjectsOp op = new DescribeSObjectsOp();
        DescribeSObjectsResponse dResponse = (DescribeSObjectsResponse)op.execute(descrParam);
        ArrayList<SObjectDescription> descrList = new ArrayList<SObjectDescription>();
        for (DescribeSObjectResultType result : dResponse.getResult()) {
            SObjectDescription descr = new SObjectDescription(result);
            descrList.add(descr);
        }
        logger.exit(descrList);
        return descrList;
    }

    @Override
    @Nonnull
    public synchronized List<EmptyRecycleBinResult> emptyRecycleBin(@Nonnull List<Id> ids) throws ApiException {
        logger.entry(new Object[]{ids});
        EmptyRecycleBin param = new EmptyRecycleBin();
        for (Id id : ids) {
            param.getIds().add(id.toString());
        }
        EmptyRecycleBinOp op = new EmptyRecycleBinOp();
        EmptyRecycleBinResponse response = (EmptyRecycleBinResponse)op.execute(param);
        ArrayList<EmptyRecycleBinResult> list = new ArrayList<EmptyRecycleBinResult>();
        for (EmptyRecycleBinResultType stubResult : response.getResult()) {
            list.add(new EmptyRecycleBinResult(stubResult));
        }
        logger.exit(list);
        return list;
    }

    @Override
    @Nonnull
    public synchronized DateTime getServerTimestamp() throws ApiException {
        logger.entry(new Object[0]);
        GetServerTimestamp param = new GetServerTimestamp();
        GetServerTimestampOp op = new GetServerTimestampOp();
        GetServerTimestampResponse response = (GetServerTimestampResponse)op.execute(param);
        GetServerTimestampResultType result = response.getResult();
        XMLGregorianCalendar serverTime = result.getTimestamp();
        DateTime time = ApiUtils.convertSFTimeToDateTime(serverTime);
        logger.exit((Object)time);
        return time;
    }

    @Override
    @Nonnull
    public synchronized UserInfo getUserInfo() throws ApiException {
        logger.entry(new Object[0]);
        GetUserInfo param = new GetUserInfo();
        GetUserInfoOp op = new GetUserInfoOp();
        GetUserInfoResponse response = (GetUserInfoResponse)op.execute(param);
        UserInfo result = new UserInfo(response.getResult());
        logger.exit((Object)result);
        return result;
    }

    @Override
    @Nonnull
    public synchronized PartnerQueryResult query(@Nonnull String queryStr) throws ApiException {
        return this.getQueryResultForStub(this.queryImpl(queryStr));
    }

    @Override
    @Nonnull
    public synchronized PartnerQueryResult queryAll(@Nonnull String queryStr) throws ApiException {
        return this.getQueryResultForStub(this.queryAllImpl(queryStr));
    }

    @Override
    @Nonnull
    public synchronized PartnerQueryResult queryMore(@Nonnull PartnerQueryLocator locator) throws ApiException {
        logger.entry(new Object[]{locator});
        QueryMore qmParam = new QueryMore();
        qmParam.setQueryLocator(locator.getContents());
        QueryMoreOp op = new QueryMoreOp();
        QueryMoreResponse qmResponse = (QueryMoreResponse)op.execute(qmParam);
        QueryResultType qmResultStub = qmResponse.getResult();
        PartnerQueryResult qResult = this.getQueryResultForStub(qmResultStub);
        logger.exit((Object)qResult);
        return qResult;
    }

    @Override
    @Nonnull
    public synchronized List<com.palominolabs.crm.sf.core.SObject> retrieve(@Nonnull String sObjectType, @Nonnull List<Id> ids, @Nonnull List<String> fieldList) throws ApiException {
        logger.entry(new Object[]{sObjectType, fieldList, ids});
        Retrieve retrieveParam = new Retrieve();
        retrieveParam.setFieldList(StringUtils.join(fieldList, (String)","));
        retrieveParam.setSObjectType(sObjectType);
        ArrayList<String> idStrings = new ArrayList<String>();
        for (Id id : ids) {
            idStrings.add(id.toString());
        }
        retrieveParam.getIds().addAll(idStrings);
        logger.trace("retrieving fields <{}> for ids <{}>", fieldList, ids);
        RetrieveOp op = new RetrieveOp();
        RetrieveResponse response = (RetrieveResponse)op.execute(retrieveParam);
        List stubSObjects = response.getResult();
        List<PartnerSObject> facadeSObjects = this.getSObjectsFromStubs(stubSObjects);
        logger.exit(facadeSObjects);
        return new ArrayList<com.palominolabs.crm.sf.core.SObject>(facadeSObjects);
    }

    @Override
    @Nonnull
    public synchronized Map<Id, com.palominolabs.crm.sf.core.SObject> retrieveExtended(@Nonnull String sObjectType, @Nonnull List<Id> ids, @Nonnull List<String> fields, int maxFieldNameChunkSize) throws ApiException {
        HashMap<Id, com.palominolabs.crm.sf.core.SObject> inProgressMap = new HashMap<Id, com.palominolabs.crm.sf.core.SObject>();
        for (Id id : ids) {
            inProgressMap.put(id, PartnerSObjectImpl.getNewWithId(sObjectType, id));
        }
        List<List<String>> fieldNameChunks = ConnectionUtils.splitFieldList(fields, maxFieldNameChunkSize);
        for (List<String> fieldListChunk : fieldNameChunks) {
            List<com.palominolabs.crm.sf.core.SObject> retrievedSObjects;
            ArrayList<Id> idList = new ArrayList<Id>(inProgressMap.keySet());
            try {
                retrievedSObjects = this.retrieve(sObjectType, idList, fieldListChunk);
            }
            catch (ApiException e) {
                throw this.getApiExceptionWithCause("Couldn't retrieve a field name chunk", e);
            }
            if (retrievedSObjects.size() != idList.size()) {
                throw ApiException.getNew("Not all Ids had records retrieved", this.getUsername());
            }
            Iterator<com.palominolabs.crm.sf.core.SObject> retrievedSObjIter = retrievedSObjects.iterator();
            Iterator idIter = idList.iterator();
            while (retrievedSObjIter.hasNext()) {
                com.palominolabs.crm.sf.core.SObject retrievedSObj = retrievedSObjIter.next();
                Id currentId = (Id)idIter.next();
                if (retrievedSObj != null) continue;
                logger.info("Could not retrieve for id <" + currentId + ">: got back null. Removing from the in progress map. This can mean" + " that field permissions are set wrong or that the fields selected" + " have caused an internal error on Salesforce's side, perhaps because " + "the generated SQL exceeded their Oracle install's max query length.");
                inProgressMap.remove(currentId);
                retrievedSObjIter.remove();
            }
            for (com.palominolabs.crm.sf.core.SObject retrievedCopy : retrievedSObjects) {
                com.palominolabs.crm.sf.core.SObject inProgressCopy = (com.palominolabs.crm.sf.core.SObject)inProgressMap.get(retrievedCopy.getId());
                if (inProgressCopy == null) {
                    throw ApiException.getNew("Somehow got an SObject back from retrieve() with an Id that we did not ask for", this.getUsername());
                }
                inProgressCopy.setAllFields(retrievedCopy.getAllFields());
            }
        }
        return inProgressMap;
    }

    @Override
    @Nonnull
    public synchronized List<UndeleteResult> undelete(@Nonnull List<Id> ids) throws ApiException {
        logger.entry(new Object[]{ids});
        Undelete param = new Undelete();
        for (Id id : ids) {
            param.getIds().add(id.toString());
        }
        UndeleteOp op = new UndeleteOp();
        UndeleteResponse response = (UndeleteResponse)op.execute(param);
        ArrayList<UndeleteResult> results = new ArrayList<UndeleteResult>();
        for (UndeleteResultType undeleteResultType : response.getResult()) {
            results.add(new UndeleteResult(undeleteResultType));
        }
        logger.exit(results);
        return results;
    }

    @Override
    @Nonnull
    public synchronized List<SaveResult> update(@Nonnull List<com.palominolabs.crm.sf.core.SObject> sObjects) throws ApiException {
        logger.entry(new Object[]{sObjects});
        Update param = new Update();
        List stubSObjectList = param.getSObjects();
        this.writeSObjectsToStubSObjectList(sObjects, stubSObjectList);
        UpdateOp op = new UpdateOp();
        UpdateResponse response = (UpdateResponse)op.execute(param);
        ArrayList<SaveResult> results = new ArrayList<SaveResult>();
        for (SaveResultType stubResult : response.getResult()) {
            results.add(new SaveResultImpl(stubResult));
        }
        logger.exit(results);
        return results;
    }

    @Override
    @Nonnull
    public synchronized List<UpsertResult> upsert(@Nonnull String externalIdFieldName, @Nonnull List<com.palominolabs.crm.sf.core.SObject> sObjects) throws ApiException {
        logger.entry(new Object[]{sObjects});
        Upsert param = new Upsert();
        param.setExternalIDFieldName(externalIdFieldName);
        List stubSObjectList = param.getSObjects();
        this.writeSObjectsToStubSObjectList(sObjects, stubSObjectList);
        UpsertOp op = new UpsertOp();
        UpsertResponse upsertResponse = (UpsertResponse)op.execute(param);
        ArrayList<UpsertResult> results = new ArrayList<UpsertResult>();
        for (UpsertResultType upsertResultType : upsertResponse.getResult()) {
            results.add(new UpsertResult(upsertResultType));
        }
        logger.exit(results);
        return results;
    }

    @VisibleForTesting
    synchronized void logout() throws ApiException {
        LogoutOp op = new LogoutOp();
        op.execute(new Logout());
    }

    private void writeSObjectsToStubSObjectList(List<com.palominolabs.crm.sf.core.SObject> sObjects, List<SObject> stubSObjectList) throws ApiException {
        for (com.palominolabs.crm.sf.core.SObject sObj : sObjects) {
            try {
                stubSObjectList.add(SObjects.convertFacadeSObjectToStubSObject(sObj));
            }
            catch (SObjectConversionException e) {
                throw this.getApiExceptionWithCause("Couldn't convert an sobject to a stub sobject", e);
            }
        }
    }

    @Nonnull
    private PartnerQueryResult getQueryResultForStub(@Nonnull QueryResultType qResultStub) throws ApiException {
        List<PartnerSObject> facadeSObjects = this.getSObjectsFromStubs(qResultStub.getRecords());
        if (qResultStub.isDone()) {
            return PartnerQueryResultImpl.getDone(facadeSObjects, qResultStub.getSize());
        }
        return PartnerQueryResultImpl.getNotDone(facadeSObjects, qResultStub.getSize(), new PartnerQueryLocator(qResultStub.getQueryLocator()));
    }

    private List<PartnerSObject> getSObjectsFromStubs(List<SObject> stubs) throws ApiException {
        try {
            return SObjects.convertStubListToSObjectList(stubs);
        }
        catch (SObjectConversionException e) {
            throw ApiException.getNewWithCause("Couldn't extract data from stub SObjects", this.getUsername(), e);
        }
    }

    private QueryResultType queryImpl(String queryStr) throws ApiException {
        logger.entry(new Object[]{queryStr});
        Query queryParam = new Query();
        queryParam.setQueryString(queryStr);
        QueryOp op = new QueryOp();
        QueryResponse qResponse = (QueryResponse)op.execute(queryParam);
        QueryResultType result = qResponse.getResult();
        logger.exit((Object)result);
        return result;
    }

    private QueryResultType queryAllImpl(String queryStr) throws ApiException {
        logger.entry(new Object[]{queryStr});
        QueryAll queryParam = new QueryAll();
        queryParam.setQueryString(queryStr);
        QueryAllOp op = new QueryAllOp();
        QueryAllResponse qResponse = (QueryAllResponse)op.execute(queryParam);
        QueryResultType result = qResponse.getResult();
        logger.exit((Object)result);
        return result;
    }

    private class UndeleteOp
    extends PartnerApiOperation<Undelete, UndeleteResponse> {
        private UndeleteOp() {
        }

        @Override
        UndeleteResponse executeOp(@Nonnull Soap binding, @Nonnull Undelete param) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidQueryLocatorFault_Exception, InvalidSObjectFault_Exception, MalformedQueryFault_Exception, UnexpectedErrorFault_Exception {
            return binding.undelete(param);
        }
    }

    private class LogoutOp
    extends PartnerApiOperation<Logout, LogoutResponse> {
        private LogoutOp() {
        }

        @Override
        LogoutResponse executeOp(@Nonnull Soap binding, @Nonnull Logout param) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidQueryLocatorFault_Exception, InvalidSObjectFault_Exception, MalformedQueryFault_Exception, UnexpectedErrorFault_Exception {
            return binding.logout(param);
        }
    }

    private class UpsertOp
    extends PartnerApiOperation<Upsert, UpsertResponse> {
        private UpsertOp() {
        }

        @Override
        UpsertResponse executeOp(@Nonnull Soap binding, @Nonnull Upsert param) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidQueryLocatorFault_Exception, InvalidSObjectFault_Exception, MalformedQueryFault_Exception, UnexpectedErrorFault_Exception {
            return binding.upsert(param);
        }
    }

    private class UpdateOp
    extends PartnerApiOperation<Update, UpdateResponse> {
        private UpdateOp() {
        }

        @Override
        UpdateResponse executeOp(@Nonnull Soap binding, @Nonnull Update param) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidSObjectFault_Exception, UnexpectedErrorFault_Exception {
            return binding.update(param);
        }
    }

    private class RetrieveOp
    extends PartnerApiOperation<Retrieve, RetrieveResponse> {
        private RetrieveOp() {
        }

        @Override
        RetrieveResponse executeOp(@Nonnull Soap binding, @Nonnull Retrieve param) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidSObjectFault_Exception, MalformedQueryFault_Exception, UnexpectedErrorFault_Exception {
            return binding.retrieve(param);
        }
    }

    private class QueryOp
    extends PartnerApiOperation<Query, QueryResponse> {
        private QueryOp() {
        }

        @Override
        QueryResponse executeOp(@Nonnull Soap binding, @Nonnull Query param) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidQueryLocatorFault_Exception, InvalidSObjectFault_Exception, MalformedQueryFault_Exception, UnexpectedErrorFault_Exception {
            return binding.query(param);
        }
    }

    private class QueryMoreOp
    extends PartnerApiOperation<QueryMore, QueryMoreResponse> {
        private QueryMoreOp() {
        }

        @Override
        QueryMoreResponse executeOp(@Nonnull Soap binding, @Nonnull QueryMore param) throws InvalidFieldFault_Exception, InvalidQueryLocatorFault_Exception, UnexpectedErrorFault_Exception, MalformedQueryFault_Exception {
            return binding.queryMore(param);
        }
    }

    private class QueryAllOp
    extends PartnerApiOperation<QueryAll, QueryAllResponse> {
        private QueryAllOp() {
        }

        @Override
        QueryAllResponse executeOp(@Nonnull Soap binding, @Nonnull QueryAll param) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidQueryLocatorFault_Exception, InvalidSObjectFault_Exception, MalformedQueryFault_Exception, UnexpectedErrorFault_Exception {
            return binding.queryAll(param);
        }
    }

    private class GetUserInfoOp
    extends PartnerApiOperation<GetUserInfo, GetUserInfoResponse> {
        private GetUserInfoOp() {
        }

        @Override
        GetUserInfoResponse executeOp(@Nonnull Soap binding, @Nonnull GetUserInfo param) throws UnexpectedErrorFault_Exception {
            return binding.getUserInfo(param);
        }
    }

    private class GetServerTimestampOp
    extends PartnerApiOperation<GetServerTimestamp, GetServerTimestampResponse> {
        private GetServerTimestampOp() {
        }

        @Override
        GetServerTimestampResponse executeOp(@Nonnull Soap binding, @Nonnull GetServerTimestamp param) throws UnexpectedErrorFault_Exception {
            return binding.getServerTimestamp(param);
        }
    }

    private class EmptyRecycleBinOp
    extends PartnerApiOperation<EmptyRecycleBin, EmptyRecycleBinResponse> {
        private EmptyRecycleBinOp() {
        }

        @Override
        EmptyRecycleBinResponse executeOp(@Nonnull Soap binding, @Nonnull EmptyRecycleBin param) throws UnexpectedErrorFault_Exception {
            return binding.emptyRecycleBin(param);
        }
    }

    private class DescribeSObjectsOp
    extends PartnerApiOperation<DescribeSObjects, DescribeSObjectsResponse> {
        private DescribeSObjectsOp() {
        }

        @Override
        DescribeSObjectsResponse executeOp(@Nonnull Soap binding, @Nonnull DescribeSObjects param) throws InvalidSObjectFault_Exception, UnexpectedErrorFault_Exception {
            return binding.describeSObjects(param);
        }
    }

    private class DescribeGlobalOp
    extends PartnerApiOperation<DescribeGlobal, DescribeGlobalResponse> {
        private DescribeGlobalOp() {
        }

        @Override
        DescribeGlobalResponse executeOp(@Nonnull Soap binding, @Nonnull DescribeGlobal param) throws UnexpectedErrorFault_Exception {
            return binding.describeGlobal(param);
        }
    }

    private class DeleteOp
    extends PartnerApiOperation<Delete, DeleteResponse> {
        private DeleteOp() {
        }

        @Override
        DeleteResponse executeOp(@Nonnull Soap binding, @Nonnull Delete param) throws UnexpectedErrorFault_Exception {
            return binding.delete(param);
        }
    }

    private class CreateOp
    extends PartnerApiOperation<Create, CreateResponse> {
        private CreateOp() {
        }

        @Override
        CreateResponse executeOp(@Nonnull Soap binding, @Nonnull Create param) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidSObjectFault_Exception, UnexpectedErrorFault_Exception {
            return binding.create(param);
        }
    }

    private abstract class PartnerApiOperation<Tin, Tout>
    extends AbstractSalesforceConnection.ApiOperation<Tin, Tout, Soap> {
        private final Timer timer;

        private PartnerApiOperation() {
            this.timer = PartnerConnectionImpl.this.metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"request"}));
        }

        @Override
        void releaseBinding(@Nonnull Soap binding) {
            PartnerConnectionImpl.this.connBundle.acceptReleasedPartnerBinding(binding);
        }

        @Override
        @Nonnull
        ConfiguredBinding<Soap> getBinding() throws ApiException {
            return PartnerConnectionImpl.this.connBundle.getPartnerBinding();
        }

        @Override
        @Nonnull
        Tout executeImpl(@Nonnull ConfiguredBinding<Soap> configuredBinding, @Nonnull Tin param) throws ApiException {
            try {
                return this.executeOpWrapper(configuredBinding, param);
            }
            catch (ApiException origApiEx) {
                if (this.isNotInvalidSessionIdFault(origApiEx)) {
                    logger.warn("Call failed", (Throwable)origApiEx);
                    throw origApiEx;
                }
                logger.info("Detected an INVALID_SESSION_ID fault for user <" + PartnerConnectionImpl.this.getUsername() + ">, attempting to re-log-in", (Throwable)origApiEx);
                try {
                    PartnerConnectionImpl.this.connBundle.reportBadSessionId();
                }
                catch (ApiException reconfEx) {
                    logger.warn("Reconfiguration failed", (Throwable)reconfEx);
                    throw ApiException.getNewWithApiExceptionCause("Reconfiguration failed", reconfEx);
                }
                ConfiguredBinding<Soap> binding2 = this.getBinding();
                logger.info("Reconfiguration succeeded, retrying");
                try {
                    Tout Tout = this.executeOpWrapper(binding2, param);
                    return Tout;
                }
                catch (ApiException retryAttemptApiEx) {
                    logger.warn("Retry after reconfiguration failed; giving up", (Throwable)retryAttemptApiEx);
                    throw retryAttemptApiEx;
                }
                finally {
                    this.releaseBinding(binding2.getBinding());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Tout executeOpWrapper(ConfiguredBinding<Soap> configuredBinding, Tin param) throws ApiException {
            Tout out;
            Timer.Context context = this.timer.time();
            try {
                PartnerConnectionImpl.this.acquireSemaphore();
                try {
                    out = this.executeOp(configuredBinding.getBinding(), param);
                }
                finally {
                    PartnerConnectionImpl.this.releaseSemaphore();
                }
            }
            catch (InvalidFieldFault_Exception e) {
                throw this.getApiExceptionWithCauseAndQueryFault("Invalid field", e, (ApiQueryFault)e.getFaultInfo());
            }
            catch (InvalidIdFault_Exception e) {
                throw this.getApiExceptionWithCauseAndFault("Invalid Id", e, (ApiFault)e.getFaultInfo());
            }
            catch (InvalidQueryLocatorFault_Exception e) {
                throw this.getApiExceptionWithCauseAndFault("Invalid query locator", e, (ApiFault)e.getFaultInfo());
            }
            catch (InvalidSObjectFault_Exception e) {
                throw this.getApiExceptionWithCauseAndQueryFault("Invalid SObject", e, (ApiQueryFault)e.getFaultInfo());
            }
            catch (MalformedQueryFault_Exception e) {
                throw this.getApiExceptionWithCauseAndQueryFault("Malformed query", e, (ApiQueryFault)e.getFaultInfo());
            }
            catch (UnexpectedErrorFault_Exception e) {
                throw this.getApiExceptionWithCauseAndFault("Unexpected error", e, (ApiFault)e.getFaultInfo());
            }
            catch (WebServiceException e) {
                throw PartnerConnectionImpl.this.getApiExceptionWithCause("Web Service exception", e);
            }
            finally {
                context.stop();
            }
            return out;
        }

        private ApiException getApiExceptionWithCauseAndQueryFault(String message, Throwable cause, ApiQueryFault f) {
            return ApiException.getNewWithCauseAndStubApiQueryFault(message, PartnerConnectionImpl.this.getUsername(), cause, f);
        }

        private ApiException getApiExceptionWithCauseAndFault(String message, Throwable cause, ApiFault f) {
            return ApiException.getNewWithCauseAndStubApiFault(message, PartnerConnectionImpl.this.getUsername(), cause, f);
        }

        private boolean isNotInvalidSessionIdFault(ApiException f) {
            return f.getApiFaultCode() != ExceptionCode.INVALID___SESSION___ID;
        }

        abstract Tout executeOp(@Nonnull Soap var1, @Nonnull Tin var2) throws InvalidFieldFault_Exception, InvalidIdFault_Exception, InvalidQueryLocatorFault_Exception, InvalidSObjectFault_Exception, MalformedQueryFault_Exception, UnexpectedErrorFault_Exception;
    }
}

