/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.core.ImmutableBitSet;
import com.palominolabs.crm.sf.core.ImmutableBitSets;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.PicklistEntryType;
import java.util.BitSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PicklistEntry {
    private final boolean active;
    private final ImmutableBitSet validFor;
    private final boolean defaultValue;
    private final String label;
    private final String value;

    PicklistEntry(PicklistEntryType stubPicklistEntry) {
        this.active = stubPicklistEntry.isActive();
        this.defaultValue = stubPicklistEntry.isDefaultValue();
        this.label = stubPicklistEntry.getLabel();
        if (stubPicklistEntry.getValue() == null) {
            throw new NullPointerException("Value for the picklist entry must not be null");
        }
        this.value = stubPicklistEntry.getValue();
        byte[] validForBytes = stubPicklistEntry.getValidFor();
        this.validFor = validForBytes == null ? new ImmutableBitSet(new BitSet()) : ImmutableBitSets.parseValidForBytes((byte[])validForBytes);
    }

    public boolean isActive() {
        return this.active;
    }

    @Nonnull
    public ImmutableBitSet getValidFor() {
        return this.validFor;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @CheckForNull
    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }
}

