/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.soap.UnpackagedComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RetrieveRequest {
    private final double apiVersion;
    @Nonnull
    private final List<String> packageNames;
    @Nonnull
    private final List<String> specificFiles;
    @Nullable
    private final UnpackagedComponents unpackagedComponents;

    private RetrieveRequest(@Nonnull List<String> packageNames, @Nonnull List<String> specificFiles, double apiVersion, @Nullable UnpackagedComponents unpackagedComponents) {
        this.apiVersion = apiVersion;
        this.packageNames = Collections.unmodifiableList(new ArrayList<String>(packageNames));
        this.specificFiles = Collections.unmodifiableList(new ArrayList<String>(specificFiles));
        this.unpackagedComponents = unpackagedComponents;
    }

    public RetrieveRequest(double apiVersion, @Nonnull List<String> packageNames, @Nonnull List<String> specificFiles, @Nonnull UnpackagedComponents unpackagedComponents) {
        this(packageNames, specificFiles, apiVersion, unpackagedComponents);
    }

    public RetrieveRequest(@Nonnull List<String> packageNames, @Nonnull List<String> specificFiles) {
        this(packageNames, specificFiles, 28.0, null);
    }

    com.palominolabs.crm.sf.soap.jaxwsstub.metadata.RetrieveRequest getStub() {
        com.palominolabs.crm.sf.soap.jaxwsstub.metadata.RetrieveRequest stub = new com.palominolabs.crm.sf.soap.jaxwsstub.metadata.RetrieveRequest();
        stub.setApiVersion(this.apiVersion);
        stub.getPackageNames().addAll(this.packageNames);
        stub.getSpecificFiles().addAll(this.specificFiles);
        stub.setSinglePackage(this.packageNames.size() == 1);
        if (this.unpackagedComponents != null) {
            stub.setUnpackaged(this.unpackagedComponents.getStub());
        }
        return stub;
    }
}

