/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.google.common.io.ByteStreams;
import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.FileProperties;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.RetrieveMessage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RetrieveResult {
    @Nonnull
    private final List<com.palominolabs.crm.sf.soap.FileProperties> fileProperties;
    @Nonnull
    private final Id id;
    @Nonnull
    private final byte[] zipFile;
    @Nonnull
    private final List<com.palominolabs.crm.sf.soap.RetrieveMessage> retrieveMessages;

    RetrieveResult(com.palominolabs.crm.sf.soap.jaxwsstub.metadata.RetrieveResult stubResult) {
        ArrayList<com.palominolabs.crm.sf.soap.FileProperties> list = new ArrayList<com.palominolabs.crm.sf.soap.FileProperties>();
        for (FileProperties stubProperties : stubResult.getFileProperties()) {
            list.add(new com.palominolabs.crm.sf.soap.FileProperties(stubProperties));
        }
        this.fileProperties = Collections.unmodifiableList(list);
        this.id = new Id(stubResult.getId());
        this.zipFile = stubResult.getZipFile();
        ArrayList<com.palominolabs.crm.sf.soap.RetrieveMessage> rmList = new ArrayList<com.palominolabs.crm.sf.soap.RetrieveMessage>();
        for (RetrieveMessage stubMessage : stubResult.getMessages()) {
            rmList.add(new com.palominolabs.crm.sf.soap.RetrieveMessage(stubMessage));
        }
        this.retrieveMessages = Collections.unmodifiableList(rmList);
    }

    @Nonnull
    public List<com.palominolabs.crm.sf.soap.FileProperties> getFileProperties() {
        return this.fileProperties;
    }

    @Nonnull
    public Id getId() {
        return this.id;
    }

    @Nonnull
    public List<com.palominolabs.crm.sf.soap.RetrieveMessage> getRetrieveMessages() {
        return this.retrieveMessages;
    }

    @Nonnull
    public ByteArrayInputStream getZipFile() {
        return new ByteArrayInputStream(this.zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Map<String, byte[]> getZipFileEntryBytes() throws IOException {
        HashMap<String, byte[]> contents = new HashMap<String, byte[]>();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(this.getZipFile()));
        try {
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ByteStreams.copy((InputStream)zis, (OutputStream)baos);
                contents.put(zipEntry.getName(), baos.toByteArray());
                zipEntry = zis.getNextEntry();
            }
        }
        finally {
            zis.close();
        }
        return contents;
    }
}

