/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.soap.PartnerQueryLocator;
import com.palominolabs.crm.sf.soap.PartnerQueryResult;
import com.palominolabs.crm.sf.soap.PartnerQueryResultImpl;
import com.palominolabs.crm.sf.soap.PartnerSObject;
import com.palominolabs.crm.sf.soap.PartnerSObjectImpl;
import com.palominolabs.crm.sf.soap.SObjectConversionException;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.SObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Immutable
final class SObjects {
    private static final EmptyDocumentFactory DOC_FACTORY = new EmptyDocumentFactory();

    private SObjects() {
    }

    @Nullable
    private static PartnerSObject convertStubSObjectToFacadeSObject(@Nullable SObject stubSObject) throws SObjectConversionException {
        if (stubSObject == null) {
            return null;
        }
        PartnerSObjectImpl newSObject = stubSObject.getId() == null ? PartnerSObjectImpl.getNew(stubSObject.getType()) : PartnerSObjectImpl.getNewWithId(stubSObject.getType(), new Id(stubSObject.getId()));
        List fields = stubSObject.getAny();
        for (Object fieldObj : fields) {
            Element xmlElt = (Element)fieldObj;
            String xsiTypeValue = xmlElt.getAttribute("xsi:type");
            String fieldName = xmlElt.getLocalName();
            if ("QueryResult".equals(xsiTypeValue)) {
                PartnerQueryResult subqueryResult = SObjects.parseQueryResult(xmlElt);
                newSObject.setRelationshipQueryResult(fieldName, subqueryResult);
                continue;
            }
            if ("sf:sObject".equals(xsiTypeValue)) {
                PartnerSObject subObj = SObjects.parseSObject(xmlElt, fieldName);
                newSObject.setRelationshipSubObject(fieldName, subObj);
                continue;
            }
            String fieldValue = SObjects.extractFieldValue(xmlElt);
            newSObject.setField(fieldName, fieldValue);
        }
        return newSObject;
    }

    @Nullable
    private static String extractFieldValue(@Nonnull Node fieldNode) {
        Node firstChild = fieldNode.getFirstChild();
        if (firstChild != null) {
            return firstChild.getNodeValue();
        }
        return null;
    }

    @Nonnull
    private static PartnerQueryResult parseQueryResult(@Nonnull Element qrElement) throws SObjectConversionException {
        NodeList childNodes = qrElement.getChildNodes();
        if (childNodes.getLength() < 3) {
            throw new SObjectConversionException("Query result element had only " + childNodes.getLength() + " nodes");
        }
        Node doneNode = childNodes.item(0);
        SObjects.checkNodeIsElement(doneNode, "done");
        boolean isDone = Boolean.parseBoolean(doneNode.getTextContent());
        ArrayList<PartnerSObject> sObjects = new ArrayList<PartnerSObject>();
        for (int i = 2; i < childNodes.getLength() - 1; ++i) {
            sObjects.add(SObjects.parseSObject(childNodes.item(i), "records"));
        }
        Node sizeNode = childNodes.item(childNodes.getLength() - 1);
        Element sizeElt = SObjects.checkNodeIsElement(sizeNode, "size");
        int sizeInt = Integer.parseInt(sizeElt.getTextContent());
        if (isDone) {
            return PartnerQueryResultImpl.getDone(sObjects, sizeInt);
        }
        Node queryLocNode = childNodes.item(1);
        Element queryLocElement = SObjects.checkNodeIsElement(queryLocNode, "queryLocator");
        String locXsiNil = queryLocElement.getAttribute("xsi:nil");
        if ("true".equals(locXsiNil)) {
            throw new SObjectConversionException("Got a nil locator with a not-done query result");
        }
        String locatorString = queryLocElement.getTextContent();
        return PartnerQueryResultImpl.getNotDone(sObjects, sizeInt, new PartnerQueryLocator(locatorString));
    }

    private static Element checkNodeIsElement(@Nullable Node node, @Nonnull String desiredElementName) throws SObjectConversionException {
        if (node == null) {
            throw new SObjectConversionException("No node found, expecting " + desiredElementName);
        }
        if (node.getNodeType() != 1) {
            throw new SObjectConversionException("Node is not an element, type is " + node.getNodeType());
        }
        if (!node.getLocalName().equals(desiredElementName)) {
            throw new SObjectConversionException("node was <" + node.getLocalName() + "> instead of " + desiredElementName);
        }
        return (Element)node;
    }

    private static PartnerSObject parseSObject(@Nonnull Node sObjectNode, String expectedNodeLocalName) throws SObjectConversionException {
        PartnerSObjectImpl sObj;
        Element sObjElt = SObjects.checkNodeIsElement(sObjectNode, expectedNodeLocalName);
        String parentNodeTypeStr = sObjElt.getAttribute("xsi:type");
        if (!"sf:sObject".equals(parentNodeTypeStr)) {
            throw new SObjectConversionException("Type of the sobject node is <" + parentNodeTypeStr + "> instead of xsi:type");
        }
        NodeList sObjChildNodes = sObjElt.getChildNodes();
        Node typeNode = sObjChildNodes.item(0);
        SObjects.checkNodeIsElement(typeNode, "type");
        String sObjTypeStr = typeNode.getTextContent();
        Node fieldsToNullOrId = sObjChildNodes.item(1);
        Element idElt = SObjects.checkNodeIsElement(fieldsToNullOrId, "Id");
        if ("true".equals(idElt.getAttribute("xsi:nil"))) {
            sObj = PartnerSObjectImpl.getNew(sObjTypeStr);
        } else {
            Id id = new Id(idElt.getTextContent());
            sObj = PartnerSObjectImpl.getNewWithId(sObjTypeStr, id);
        }
        for (int i = 2; i < sObjChildNodes.getLength(); ++i) {
            Node fieldNode = sObjChildNodes.item(i);
            String fieldName = fieldNode.getLocalName();
            String fieldValue = SObjects.extractFieldValue(fieldNode);
            sObj.setField(fieldName, fieldValue);
        }
        return sObj;
    }

    @Nonnull
    static SObject convertFacadeSObjectToStubSObject(@Nonnull com.palominolabs.crm.sf.core.SObject facadeSObject) throws SObjectConversionException {
        SObject stub = new SObject();
        if (facadeSObject.getId() == null) {
            stub.setId(null);
        } else {
            stub.setId(facadeSObject.getId().toString());
        }
        stub.setType(facadeSObject.getType());
        List stubFields = stub.getAny();
        Document doc = DOC_FACTORY.newDocument();
        for (String fieldName : facadeSObject.getAllFields().keySet()) {
            Element fieldElt;
            String value = facadeSObject.getField(fieldName);
            if (value == null) {
                stub.getFieldsToNull().add(fieldName);
                continue;
            }
            try {
                fieldElt = doc.createElement(fieldName);
                Text valueNode = doc.createTextNode(value);
                fieldElt.appendChild(valueNode);
            }
            catch (DOMException e) {
                throw new SObjectConversionException("Couldn't create DOM nodes for field name <" + fieldName + "> and value <" + value + ">", e);
            }
            stubFields.add(fieldElt);
        }
        return stub;
    }

    static List<PartnerSObject> convertStubListToSObjectList(List<SObject> stubSObjects) throws SObjectConversionException {
        ArrayList<PartnerSObject> sObjects = new ArrayList<PartnerSObject>();
        for (SObject stub : stubSObjects) {
            sObjects.add(SObjects.convertStubSObjectToFacadeSObject(stub));
        }
        return sObjects;
    }

    @ThreadSafe
    private static final class EmptyDocumentFactory {
        private final DocumentBuilder docBuilder;

        EmptyDocumentFactory() {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                this.docBuilder = docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException("Somehow the doc builder factory couldn't create a doc builder", e);
            }
        }

        synchronized Document newDocument() {
            return this.docBuilder.newDocument();
        }
    }
}

