/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.soap.AsyncResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.joda.time.Duration;

@Immutable
public final class WaitForAsyncResult {
    private final List<AsyncResult> complete;
    private final List<AsyncResult> incomplete;
    private final Duration elapsedTime;
    private final List<AsyncResult> all;

    WaitForAsyncResult(Duration elapsed, List<AsyncResult> results) {
        this.elapsedTime = elapsed;
        ArrayList<AsyncResult> mutableIncomplete = new ArrayList<AsyncResult>();
        ArrayList<AsyncResult> mutableComplete = new ArrayList<AsyncResult>();
        for (AsyncResult result : results) {
            if (result.isDone()) {
                mutableComplete.add(result);
                continue;
            }
            mutableIncomplete.add(result);
        }
        this.all = Collections.unmodifiableList(new ArrayList<AsyncResult>(results));
        this.complete = Collections.unmodifiableList(mutableComplete);
        this.incomplete = Collections.unmodifiableList(mutableIncomplete);
    }

    public List<AsyncResult> getComplete() {
        return this.complete;
    }

    public List<AsyncResult> getIncomplete() {
        return this.incomplete;
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    public List<AsyncResult> getAll() {
        return this.all;
    }
}

