/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.core;

import com.paypal.sdk.util.MessageResources;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class EndpointsReader
extends DefaultHandler {
    private static Log log = LogFactory.getLog(EndpointsReader.class);
    private boolean record = false;
    private String environment;
    private String port;
    private String version;
    private Map endpoints;
    private StringBuffer chars = new StringBuffer();

    public EndpointsReader(String version) {
        this.endpoints = new HashMap();
        this.version = version;
    }

    public boolean isSupported(String minVersionStr, String maxVersionStr) {
        if (this.version != null) {
            try {
                double minVersion = Double.parseDouble(minVersionStr);
                double maxVersion = Double.parseDouble(maxVersionStr);
                double value = Double.parseDouble(this.version);
                return value >= minVersion && value <= maxVersion;
            }
            catch (NumberFormatException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        this.chars.setLength(0);
        if (name.equals("wsdl")) {
            this.record = true;
        } else if (name.equals("environment")) {
            this.environment = atts.getValue("name");
        } else if (name.equals("port")) {
            Boolean threetoken = new Boolean(atts.getValue("threetoken"));
            this.port = threetoken != false ? atts.getValue("name") + "-threetoken" : atts.getValue("name");
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.record && name.equals("port") && this.environment != null && this.port != null) {
            this.endpoints.put(this.environment.toLowerCase() + "-" + this.port.toLowerCase(), this.chars.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format(MessageResources.getMessage("ENDPOINT_FOUND"), this.environment, this.port, this.version, this.chars.toString()));
            }
        }
        this.chars.setLength(0);
        if (name.equals("wsdl")) {
            this.record = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.chars.append(ch, start, length);
    }

    public Map getEndpoints() {
        return this.endpoints;
    }
}

