/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.profiles;

import com.paypal.sdk.profiles.APIProfile;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseAPIProfile
implements APIProfile,
Serializable {
    private static Log log = LogFactory.getLog(BaseAPIProfile.class);
    private String apiUsername = "";
    private transient String apiPassword = "";
    private transient String subject = "";
    private String environment = "sandbox";
    private int timeout;
    private int maximumRetries;
    private int delayTime;

    public BaseAPIProfile() {
        try {
            this.timeout = 60000;
            this.maximumRetries = 0;
            this.delayTime = 2000;
        }
        catch (NumberFormatException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getAPIUsername() {
        return this.apiUsername;
    }

    @Override
    public String getAPIPassword() {
        return this.apiPassword;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public int getMaximumRetries() {
        return this.maximumRetries;
    }

    @Override
    public int getDelayTime() {
        return this.delayTime;
    }

    @Override
    public void setAPIUsername(String apiUsername) {
        this.apiUsername = apiUsername;
    }

    @Override
    public void setAPIPassword(String apiPassword) {
        this.apiPassword = apiPassword;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Override
    public void setTimeout(int timeout) {
        if (timeout >= 0) {
            this.timeout = timeout;
        }
    }

    @Override
    public void setMaximumRetries(int maximumRetries) {
        if (maximumRetries >= 0) {
            this.maximumRetries = maximumRetries;
        }
    }

    @Override
    public void setDelayTime(int delayTime) {
        if (delayTime >= 0) {
            this.delayTime = delayTime;
        }
    }
}

