/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.profiles;

import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.TransactionException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.profiles.EWPProfile;
import com.paypal.sdk.util.MessageResources;
import java.text.MessageFormat;

public class ProfileFactory {
    private static final String DEFAULT_SSL_API_PROFILE = "com.paypal.sdk.profiles.CertificateAPIProfile";
    private static final String DEFAULT_UNIPAY_API_PROFILE = "com.paypal.sdk.profiles.UniPayAPIProfile";
    private static final String DEFAULT_SIGNATURE_API_PROFILE = "com.paypal.sdk.profiles.SignatureAPIProfile";
    private static final String DEFAULT_PERMISSION_API_PROFILE = "com.paypal.sdk.profiles.PermissionAPIProfile";
    private static final String DEFAULT_EWP_PROFILE = "com.paypal.sdk.profiles.DefaultEWPProfile";

    public static APIProfile createSSLAPIProfile() throws PayPalException {
        try {
            APIProfile profile = (APIProfile)Class.forName(DEFAULT_SSL_API_PROFILE).newInstance();
            return profile;
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("PROFILE_INSTANTIATION_ERROR"), DEFAULT_SSL_API_PROFILE));
        }
    }

    public static APIProfile createSignatureAPIProfile() throws PayPalException {
        try {
            APIProfile profile = (APIProfile)Class.forName(DEFAULT_SIGNATURE_API_PROFILE).newInstance();
            return profile;
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("PROFILE_INSTANTIATION_ERROR"), DEFAULT_SIGNATURE_API_PROFILE));
        }
    }

    public static APIProfile createUniPayAPIProfile() throws PayPalException {
        try {
            APIProfile profile = (APIProfile)Class.forName(DEFAULT_UNIPAY_API_PROFILE).newInstance();
            return profile;
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("PROFILE_INSTANTIATION_ERROR"), DEFAULT_UNIPAY_API_PROFILE));
        }
    }

    public static EWPProfile createEWPProfile() throws PayPalException {
        try {
            EWPProfile profile = (EWPProfile)Class.forName(DEFAULT_EWP_PROFILE).newInstance();
            return profile;
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("PROFILE_INSTANTIATION_ERROR"), DEFAULT_EWP_PROFILE));
        }
    }

    public static APIProfile createPermissionAPIProfile() throws PayPalException {
        try {
            APIProfile profile = (APIProfile)Class.forName(DEFAULT_PERMISSION_API_PROFILE).newInstance();
            return profile;
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("PROFILE_INSTANTIATION_ERROR"), DEFAULT_PERMISSION_API_PROFILE));
        }
    }
}

