/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.profiles;

import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.WarningException;
import com.paypal.sdk.profiles.ProfileHandler;
import com.paypal.sdk.profiles.Profiles;
import com.paypal.sdk.util.MessageResources;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class XMLProfileHandler
implements ProfileHandler {
    @Override
    public Profiles retrieve() throws PayPalException {
        Profiles profiles = null;
        XMLDecoder decoder = null;
        try {
            decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream("profiles")));
            profiles = (Profiles)decoder.readObject();
        }
        catch (IOException e) {
            throw new WarningException(MessageResources.getMessage("PROFILE_RETRIEVE_ERROR"), e);
        }
        finally {
            if (decoder != null) {
                decoder.close();
            }
        }
        return profiles;
    }

    @Override
    public void store(Profiles profiles) throws PayPalException {
        XMLEncoder encoder = null;
        try {
            encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream("profiles")));
            encoder.writeObject(profiles);
        }
        catch (IOException e) {
            throw new WarningException(MessageResources.getMessage("PROFILE_STORE_ERROR"), e);
        }
        finally {
            if (encoder != null) {
                encoder.close();
            }
        }
    }
}

