/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.CreateProfileResponse;
import com.paypal.api.payments.FlowConfig;
import com.paypal.api.payments.InputFields;
import com.paypal.api.payments.PatchRequest;
import com.paypal.api.payments.Presentation;
import com.paypal.core.SDKVersion;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.OAuthTokenCredential;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import com.paypal.sdk.info.SDKVersionImpl;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProfile {
    private String id;
    private String name;
    private FlowConfig flowConfig;
    private InputFields inputFields;
    private Presentation presentation;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static OAuthTokenCredential initConfig(InputStream is) throws PayPalRESTException {
        return PayPalResource.initConfig((InputStream)is);
    }

    public static OAuthTokenCredential initConfig(File file) throws PayPalRESTException {
        return PayPalResource.initConfig((File)file);
    }

    public static OAuthTokenCredential initConfig(Properties properties) {
        return PayPalResource.initConfig((Properties)properties);
    }

    public WebProfile() {
    }

    public WebProfile(String name) {
        this.name = name;
    }

    public WebProfile setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public WebProfile setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public WebProfile setFlowConfig(FlowConfig flowConfig) {
        this.flowConfig = flowConfig;
        return this;
    }

    public FlowConfig getFlowConfig() {
        return this.flowConfig;
    }

    public WebProfile setInputFields(InputFields inputFields) {
        this.inputFields = inputFields;
        return this;
    }

    public InputFields getInputFields() {
        return this.inputFields;
    }

    public WebProfile setPresentation(Presentation presentation) {
        this.presentation = presentation;
        return this;
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    public CreateProfileResponse create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public CreateProfileResponse create(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        String resourcePath = "v1/payment-experience/web-profiles";
        String payLoad = this.toJSON();
        return (CreateProfileResponse)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, CreateProfileResponse.class);
    }

    public void update(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.update(apiContext);
    }

    public void update(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payment-experience/web-profiles/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = this.toJSON();
        PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.PUT, (String)resourcePath, (String)payLoad, null);
    }

    public void partialUpdate(String accessToken, PatchRequest patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.partialUpdate(apiContext, patchRequest);
    }

    public void partialUpdate(APIContext apiContext, PatchRequest patchRequest) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payment-experience/web-profiles/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = patchRequest.toJSON();
        PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.PATCH, (String)resourcePath, (String)payLoad, null);
    }

    public static WebProfile get(String accessToken, String profileId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return WebProfile.get(apiContext, profileId);
    }

    public static WebProfile get(APIContext apiContext, String profileId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (profileId == null) {
            throw new IllegalArgumentException("profileId cannot be null");
        }
        Object[] parameters = new Object[]{profileId};
        String pattern = "v1/payment-experience/web-profiles/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (WebProfile)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, WebProfile.class);
    }

    public static List<WebProfile> getList(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return WebProfile.getList(apiContext);
    }

    public static List<WebProfile> getList(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        String resourcePath = "v1/payment-experience/web-profiles";
        String payLoad = "";
        return (List)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, new ArrayList().getClass());
    }

    public void delete(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext);
    }

    public void delete(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        apiContext.setMaskRequestId(true);
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payment-experience/web-profiles/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.DELETE, (String)resourcePath, (String)payLoad, null);
    }

    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    public String toString() {
        return this.toJSON();
    }
}

