/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.EventType;
import com.paypal.api.payments.Links;
import com.paypal.core.SDKVersion;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import com.paypal.sdk.info.SDKVersionImpl;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Webhook {
    private String id;
    private String url;
    private List<EventType> eventTypes;
    private List<Links> links;

    public Webhook() {
    }

    public Webhook(String url, List<EventType> eventTypes) {
        this.url = url;
        this.eventTypes = eventTypes;
    }

    public Webhook setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Webhook setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Webhook setEventTypes(List<EventType> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public Webhook setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Webhook create(String accessToken, Webhook webhook) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext, webhook);
    }

    public Webhook create(APIContext apiContext, Webhook webhook) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        if (webhook == null) {
            throw new IllegalArgumentException("webhook cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        Object[] parameters = new Object[]{};
        String pattern = "v1/notifications/webhooks";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = webhook.toJSON();
        return (Webhook)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Webhook.class);
    }

    public Webhook get(String accessToken, String webhookId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.get(apiContext, webhookId);
    }

    public Webhook get(APIContext apiContext, String webhookId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (Webhook)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, Webhook.class);
    }

    public Webhook update(String accessToken, String webhookId, String patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext, webhookId, patchRequest);
    }

    public Webhook update(APIContext apiContext, String webhookId, String patchRequest) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = patchRequest;
        return (Webhook)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.PATCH, (String)resourcePath, (String)payLoad, Webhook.class);
    }

    public void delete(String accessToken, String webhookId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext, webhookId);
    }

    public void delete(APIContext apiContext, String webhookId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        if (webhookId == null) {
            throw new IllegalArgumentException("webhookId cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        Object[] parameters = new Object[]{webhookId};
        String pattern = "v1/notifications/webhooks/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.DELETE, (String)resourcePath, (String)payLoad, null);
    }

    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    public String toString() {
        return this.toJSON();
    }
}

