/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.Refund;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sale {
    private String id;
    private String createTime;
    private String updateTime;
    private Amount amount;
    private String state;
    private String parentPayment;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static void initConfig(InputStream is) throws PayPalRESTException {
        PayPalResource.initConfig((InputStream)is);
    }

    public static void initConfig(File file) throws PayPalRESTException {
        PayPalResource.initConfig((File)file);
    }

    public static void initConfig(Properties properties) {
        PayPalResource.initConfig((Properties)properties);
    }

    public Sale() {
    }

    public Sale(Amount amount, String state, String parentPayment) {
        this.amount = amount;
        this.state = state;
        this.parentPayment = parentPayment;
    }

    public Sale setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Sale setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Sale setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Sale setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Sale setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Sale setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public Sale setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public static Sale get(String accessToken, String saleId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Sale.get(apiContext, saleId);
    }

    public static Sale get(APIContext apiContext, String saleId) throws PayPalRESTException {
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (saleId == null) {
            throw new IllegalArgumentException("saleId cannot be null");
        }
        Object[] parameters = new Object[]{saleId};
        String pattern = "v1/payments/sale/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (Sale)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, Sale.class);
    }

    public Refund refund(String accessToken, Refund refund) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.refund(apiContext, refund);
    }

    public Refund refund(APIContext apiContext, Refund refund) throws PayPalRESTException {
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (refund == null) {
            throw new IllegalArgumentException("refund cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/sale/{0}/refund";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = refund.toJSON();
        return (Refund)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Refund.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    public String toString() {
        return this.toJSON();
    }
}

