/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.Refund;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sale
extends PayPalResource {
    private String id;
    private String createTime;
    private String updateTime;
    private Amount amount;
    private String paymentMode;
    private String state;
    private String reasonCode;
    private String protectionEligibility;
    private String protectionEligibilityType;
    private String clearingTime;
    private String parentPayment;
    private List<Links> links;

    public Sale() {
    }

    public Sale(Amount amount, String state, String parentPayment) {
        this.amount = amount;
        this.state = state;
        this.parentPayment = parentPayment;
    }

    public Sale setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Sale setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Sale setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Sale setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Sale setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
        return this;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public Sale setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Sale setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public Sale setProtectionEligibility(String protectionEligibility) {
        this.protectionEligibility = protectionEligibility;
        return this;
    }

    public String getProtectionEligibility() {
        return this.protectionEligibility;
    }

    public Sale setProtectionEligibilityType(String protectionEligibilityType) {
        this.protectionEligibilityType = protectionEligibilityType;
        return this;
    }

    public String getProtectionEligibilityType() {
        return this.protectionEligibilityType;
    }

    public Sale setClearingTime(String clearingTime) {
        this.clearingTime = clearingTime;
        return this;
    }

    public String getClearingTime() {
        return this.clearingTime;
    }

    public Sale setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public Sale setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public static Sale get(String accessToken, String saleId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Sale.get(apiContext, saleId);
    }

    public static Sale get(APIContext apiContext, String saleId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (saleId == null) {
            throw new IllegalArgumentException("saleId cannot be null");
        }
        Object[] parameters = new Object[]{saleId};
        String pattern = "v1/payments/sale/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Sale.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Sale.class);
    }

    public Refund refund(String accessToken, Refund refund) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.refund(apiContext, refund);
    }

    public Refund refund(APIContext apiContext, Refund refund) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (refund == null) {
            throw new IllegalArgumentException("refund cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/sale/{0}/refund";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = refund.toJSON();
        return Sale.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Refund.class);
    }
}

