/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.paypal.base.APICallPreHandler;
import com.paypal.base.ConfigManager;
import com.paypal.base.ConnectionManager;
import com.paypal.base.HttpConfiguration;
import com.paypal.base.HttpConnection;
import com.paypal.base.SDKUtil;
import com.paypal.base.SDKVersion;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.OAuthTokenCredential;
import com.paypal.base.rest.PayPalModel;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.RESTAPICallPreHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PayPalResource
extends PayPalModel {
    private static final Logger log = LogManager.getLogger(PayPalResource.class);
    private static Map<String, String> configurationMap;
    private static boolean configInitialized;
    private static final ThreadLocal<String> LASTREQUEST;
    private static final ThreadLocal<String> LASTRESPONSE;

    public static OAuthTokenCredential initConfig(File file) throws PayPalRESTException {
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("File doesn't exist: " + file.getAbsolutePath());
            }
            FileInputStream fis = new FileInputStream(file);
            return PayPalResource.initConfig(fis);
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), (Throwable)ioe);
            throw new PayPalRESTException(ioe.getMessage(), ioe);
        }
    }

    public static OAuthTokenCredential initConfig(Properties properties) {
        configurationMap = SDKUtil.constructMap(properties);
        configInitialized = true;
        return PayPalResource.getOAuthTokenCredential();
    }

    public static OAuthTokenCredential initConfig(InputStream inputStream) throws PayPalRESTException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            configurationMap = SDKUtil.constructMap(properties);
            configInitialized = true;
            return PayPalResource.getOAuthTokenCredential();
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), (Throwable)ioe);
            throw new PayPalRESTException(ioe.getMessage(), ioe);
        }
    }

    public static String getClientID() {
        return configurationMap.get("clientId");
    }

    public static String getClientSecret() {
        return configurationMap.get("clientSecret");
    }

    public static OAuthTokenCredential getOAuthTokenCredential() {
        if (configInitialized) {
            return new OAuthTokenCredential(PayPalResource.getClientID(), PayPalResource.getClientSecret(), configurationMap);
        }
        return new OAuthTokenCredential(PayPalResource.getClientID(), PayPalResource.getClientSecret());
    }

    public static void initializeToDefault() throws PayPalRESTException {
        configurationMap = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
    }

    public static String getLastRequest() {
        return LASTREQUEST.get();
    }

    public static String getLastResponse() {
        return LASTRESPONSE.get();
    }

    public static <T> T configureAndExecute(String accessToken, HttpMethod httpMethod, String resourcePath, String payLoad, Class<T> clazz) throws PayPalRESTException {
        return PayPalResource.configureAndExecute(null, accessToken, httpMethod, resourcePath, null, payLoad, null, clazz);
    }

    public static <T> T configureAndExecute(APIContext apiContext, HttpMethod httpMethod, String resourcePath, String payLoad, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        Map<String, String> cMap = null;
        String accessToken = null;
        String requestId = null;
        Map<String, String> headersMap = null;
        if (apiContext != null) {
            if (apiContext.getConfigurationMap() != null) {
                cMap = SDKUtil.combineDefaultMap(apiContext.getConfigurationMap());
            } else {
                if (!configInitialized) {
                    PayPalResource.initializeToDefault();
                }
                cMap = new HashMap<String, String>(configurationMap);
            }
            headersMap = apiContext.getHTTPHeaders();
            accessToken = apiContext.getAccessToken();
            requestId = apiContext.getRequestId();
            APICallPreHandler apiCallPreHandler = PayPalResource.createAPICallPreHandler(cMap, payLoad, resourcePath, headersMap, accessToken, requestId, apiContext.getSdkVersion());
            HttpConfiguration httpConfiguration = PayPalResource.createHttpConfiguration(cMap, httpMethod, apiCallPreHandler);
            t = PayPalResource.execute(apiCallPreHandler, httpConfiguration, clazz);
        }
        return t;
    }

    public static <T> T configureAndExecute(APIContext apiContext, HttpMethod httpMethod, String resourcePath, Map<String, String> headersMap, String payLoad, Class<T> clazz) throws PayPalRESTException {
        Map<String, String> cMap = null;
        String accessToken = null;
        String requestId = null;
        if (apiContext != null) {
            cMap = apiContext.getConfigurationMap();
            accessToken = apiContext.getAccessToken();
            requestId = apiContext.getRequestId();
        }
        return PayPalResource.configureAndExecute(cMap, accessToken, httpMethod, resourcePath, headersMap, payLoad, requestId, clazz);
    }

    private static <T> T configureAndExecute(Map<String, String> configurationMap, String accessToken, HttpMethod httpMethod, String resourcePath, Map<String, String> headersMap, String payLoad, String requestId, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        Map<String, String> cMap = null;
        if (configurationMap != null) {
            cMap = SDKUtil.combineDefaultMap(configurationMap);
        } else {
            if (!configInitialized) {
                PayPalResource.initializeToDefault();
            }
            cMap = new HashMap<String, String>(configurationMap);
        }
        APICallPreHandler apiCallPreHandler = PayPalResource.createAPICallPreHandler(cMap, payLoad, resourcePath, headersMap, accessToken, requestId, null);
        HttpConfiguration httpConfiguration = PayPalResource.createHttpConfiguration(cMap, httpMethod, apiCallPreHandler);
        t = PayPalResource.execute(apiCallPreHandler, httpConfiguration, clazz);
        return t;
    }

    public static APICallPreHandler createAPICallPreHandler(Map<String, String> configurationMap, String payLoad, String resourcePath, Map<String, String> headersMap, String accessToken, String requestId, SDKVersion sdkVersion) {
        RESTAPICallPreHandler apiCallPreHandler = null;
        RESTAPICallPreHandler restAPICallPreHandler = new RESTAPICallPreHandler(configurationMap, headersMap);
        restAPICallPreHandler.setResourcePath(resourcePath);
        restAPICallPreHandler.setRequestId(requestId);
        restAPICallPreHandler.setAuthorizationToken(accessToken);
        restAPICallPreHandler.setPayLoad(payLoad);
        restAPICallPreHandler.setSdkVersion(sdkVersion);
        apiCallPreHandler = restAPICallPreHandler;
        return apiCallPreHandler;
    }

    private static <T> T execute(APICallPreHandler apiCallPreHandler, HttpConfiguration httpConfiguration, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        try {
            Map<String, String> headers = apiCallPreHandler.getHeaderMap();
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            HttpConnection httpConnection = connectionManager.getConnection(httpConfiguration);
            httpConnection.createAndconfigureHttpConnection(httpConfiguration);
            LASTREQUEST.set(apiCallPreHandler.getPayLoad());
            String responseString = httpConnection.execute(null, apiCallPreHandler.getPayLoad(), headers);
            LASTRESPONSE.set(responseString);
            if (clazz != null) {
                t = JSONFormatter.fromJSON(responseString, clazz);
            }
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return t;
    }

    private static HttpConfiguration createHttpConfiguration(Map<String, String> configurationMap, HttpMethod httpMethod, APICallPreHandler apiCallPreHandler) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod(httpMethod.toString());
        httpConfiguration.setEndPointUrl(apiCallPreHandler.getEndPoint());
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(configurationMap.get("http.GoogleAppEngine")));
        if (Boolean.parseBoolean(configurationMap.get("http.UseProxy"))) {
            httpConfiguration.setProxyPort(Integer.parseInt(configurationMap.get("http.ProxyPort")));
            httpConfiguration.setProxyHost(configurationMap.get("http.ProxyHost"));
            httpConfiguration.setProxyUserName(configurationMap.get("http.ProxyUserName"));
            httpConfiguration.setProxyPassword(configurationMap.get("http.ProxyPassword"));
        }
        httpConfiguration.setConnectionTimeout(Integer.parseInt(configurationMap.get("http.ConnectionTimeOut")));
        httpConfiguration.setMaxRetry(Integer.parseInt(configurationMap.get("http.Retry")));
        httpConfiguration.setReadTimeout(Integer.parseInt(configurationMap.get("http.ReadTimeOut")));
        httpConfiguration.setMaxHttpConnection(Integer.parseInt(configurationMap.get("http.MaxConnection")));
        httpConfiguration.setIpAddress(configurationMap.get("http.IPAddress"));
        return httpConfiguration;
    }

    static {
        configInitialized = false;
        LASTREQUEST = new ThreadLocal();
        LASTRESPONSE = new ThreadLocal();
    }
}

