/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.plugin;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ClassLoaderUtils.class);
    private static ClassLoader originalClassLoader;

    private ClassLoaderUtils() {
    }

    public static void addLocationsToClassLoader(MavenProject mavenProject) throws MojoExecutionException {
        ArrayList urls = Lists.newArrayList();
        try {
            urls.add(new File(mavenProject.getBuild().getOutputDirectory()).toURI().toURL());
            Set artifacts = mavenProject.getArtifacts();
            for (Artifact artifact : artifacts) {
                urls.add(artifact.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(urls.toArray(new URL[urls.size()]), originalClassLoader));
    }

    public static List<String> loadPackages(MavenProject mavenProject) throws MojoExecutionException {
        ArrayList packages = Lists.newArrayList();
        logger.info("Loading packages in " + mavenProject.getBuild().getSourceDirectory() + "...");
        File rootDir = new File(mavenProject.getBuild().getSourceDirectory() + "//");
        Collection files = FileUtils.listFilesAndDirs((File)rootDir, (IOFileFilter)DirectoryFileFilter.DIRECTORY, (IOFileFilter)TrueFileFilter.TRUE);
        for (File file : files) {
            String pack = file.toString().replace(rootDir.toString(), "").replace(File.separator, ".");
            if (pack.startsWith(".")) {
                pack = pack.substring(1, pack.length());
            }
            if (pack.isEmpty()) continue;
            packages.add(pack);
        }
        return packages;
    }

    public static List<String> loadClasses(MavenProject mavenProject) throws MojoExecutionException {
        ArrayList classes = Lists.newArrayList();
        File rootDir = new File(mavenProject.getBuild().getSourceDirectory());
        Collection files = FileUtils.listFiles((File)rootDir, (IOFileFilter)new SuffixFileFilter(".java"), (IOFileFilter)TrueFileFilter.TRUE);
        for (File file : files) {
            String clazz = file.getName().replace(".java", "");
            if (clazz.isEmpty()) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static void restoreOriginalClassLoader() throws MojoExecutionException {
        if (originalClassLoader == null) {
            throw new MojoExecutionException("Original ClassLoader not available.");
        }
        Thread.currentThread().setContextClassLoader(originalClassLoader);
    }
}

