/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.plugin;

import com.google.common.base.Strings;
import com.google.common.reflect.ClassPath;
import com.phoenixnap.oss.ramlapisync.data.ApiDocumentMetadata;
import com.phoenixnap.oss.ramlapisync.plugin.ClassLoaderUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class CommonApiSyncMojo
extends AbstractMojo {
    @Parameter(required=false, readonly=true, defaultValue="1")
    protected String version;
    @Parameter(required=false, readonly=true, defaultValue="application/json")
    protected String defaultMediaType;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(required=false, readonly=true, defaultValue="")
    protected String javaDocPath;
    protected Set<ApiDocumentMetadata> documents = new LinkedHashSet<ApiDocumentMetadata>();
    private static final String DEFAULT_RESOURCE_DOC_SUFFIX = "-doc.md";
    @Parameter(required=false, readonly=true, defaultValue="-doc.md")
    protected String documentationSuffix;
    @Parameter(readonly=true)
    protected List<String> ignoredList = Collections.emptyList();
    @Parameter(readonly=true)
    protected List<String> dependencyPackagesList = Collections.emptyList();
    protected List<Class<?>> annotatedClasses = new ArrayList();
    protected Class<? extends Annotation>[] supportedClassAnnotations = this.getSupportedClassAnnotations();

    protected void prepareRaml() throws MojoExecutionException, MojoFailureException, IOException {
        ClassLoaderUtils.addLocationsToClassLoader(this.project);
        List<String> targetPacks = ClassLoaderUtils.loadPackages(this.project);
        if (this.dependencyPackagesList != null && !this.dependencyPackagesList.isEmpty()) {
            targetPacks.addAll(this.dependencyPackagesList);
        }
        ClassPath classPath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
        for (String pack : targetPacks) {
            this.scanPack(pack, classPath);
        }
        for (ClassPath.ResourceInfo resourceInfo : classPath.getResources()) {
            if (!resourceInfo.getResourceName().endsWith(this.documentationSuffix)) continue;
            try {
                this.documents.add(new ApiDocumentMetadata(resourceInfo, this.documentationSuffix));
                this.getLog().info((CharSequence)("Adding Documentation File " + resourceInfo.getResourceName()));
            }
            catch (Throwable ex) {
                this.getLog().warn((CharSequence)("Skipping Resource: Unable to load" + resourceInfo.getResourceName()), ex);
            }
        }
        ClassLoaderUtils.restoreOriginalClassLoader();
    }

    protected final void scanClass(Class<?> c) {
        for (Class<? extends Annotation> cAnnotation : this.supportedClassAnnotations) {
            if (!c.isAnnotationPresent(cAnnotation)) continue;
            this.annotatedClasses.add(c);
        }
    }

    protected void scanPack(String pack, ClassPath classPath) throws MojoExecutionException, IOException {
        this.getLog().info((CharSequence)("Scanning package " + pack));
        if (Strings.isNullOrEmpty((String)pack)) {
            ClassLoaderUtils.restoreOriginalClassLoader();
            throw new MojoExecutionException("Invalid target package: " + pack);
        }
        for (ClassPath.ClassInfo classInfo : classPath.getTopLevelClasses(pack)) {
            try {
                Class c = classInfo.load();
                if (this.ignoredList.contains(c.getPackage().getName()) || this.ignoredList.contains(c.getName())) continue;
                this.scanClass(c);
            }
            catch (Throwable ex) {
                this.getLog().warn((CharSequence)("Skipping Class: Unable to load" + classInfo.getName()), ex);
            }
        }
    }

    protected Class<? extends Annotation>[] getSupportedClassAnnotations() {
        return new Class[0];
    }
}

