/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.plugin;

import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.generation.RamlParser;
import com.phoenixnap.oss.ramlapisync.generation.rules.ConfigurableRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.phoenixnap.oss.ramlapisync.generation.rules.Spring4ControllerStubRule;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.plugin.ClassLoaderUtils;
import com.phoenixnap.oss.ramlapisync.plugin.PojoGenerationConfig;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson1Annotator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Mojo(name="generate-springmvc-endpoints", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class SpringMvcEndpointGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor descriptor;
    @Parameter(required=true, readonly=true, defaultValue="")
    protected String ramlPath;
    @Parameter(required=false, readonly=true, defaultValue="")
    protected String outputRelativePath;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean addTimestampFolder;
    @Parameter(required=true, readonly=true, defaultValue="")
    protected String basePackage;
    @Parameter(required=false, readonly=true, defaultValue="")
    protected String schemaLocation;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean generateUnreferencedSchemas;
    @Parameter(required=false, readonly=true)
    protected String baseUri;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean seperateMethodsByContentType;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean useJackson1xCompatibility;
    @Parameter(required=false, readonly=true, defaultValue="com.phoenixnap.oss.ramlapisync.generation.rules.Spring4ControllerStubRule")
    protected String rule;
    @Parameter(required=false, readonly=true)
    protected Map<String, String> ruleConfiguration = new LinkedHashMap<String, String>();
    @Parameter(required=false, readonly=true)
    protected PojoGenerationConfig generationConfig = new PojoGenerationConfig();
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean injectHttpHeadersParameter;
    private ClassRealm classRealm;
    private String resolvedSchemaLocation;

    protected void generateEndpoints() throws MojoExecutionException, MojoFailureException, IOException {
        String resolvedPath = this.project.getBasedir().getAbsolutePath();
        if (resolvedPath.endsWith(File.separator) || resolvedPath.endsWith("/")) {
            resolvedPath = resolvedPath.substring(0, resolvedPath.length() - 1);
        }
        String resolvedRamlPath = this.project.getBasedir().getAbsolutePath();
        resolvedRamlPath = !this.ramlPath.startsWith(File.separator) && !this.ramlPath.startsWith("/") ? resolvedRamlPath + File.separator + this.ramlPath : resolvedRamlPath + this.ramlPath;
        this.resolvedSchemaLocation = this.getSchemaLocation();
        RamlRoot loadRamlFromFile = RamlParser.loadRamlFromFile((String)new File(resolvedRamlPath).toURI().toString());
        RamlParser par = new RamlParser(this.basePackage, this.getBasePath(loadRamlFromFile), this.seperateMethodsByContentType.booleanValue(), this.injectHttpHeadersParameter.booleanValue());
        Set controllers = par.extractControllers(loadRamlFromFile);
        if (StringUtils.hasText((String)this.outputRelativePath)) {
            if (!this.outputRelativePath.startsWith(File.separator) && !this.outputRelativePath.startsWith("/")) {
                resolvedPath = resolvedPath + File.separator;
            }
            resolvedPath = resolvedPath + this.outputRelativePath;
        } else {
            resolvedPath = resolvedPath + "/target/generated-sources/spring-mvc";
        }
        File rootDir = new File(resolvedPath + (this.addTimestampFolder == true ? Long.valueOf(System.currentTimeMillis()) : "") + "/");
        if (!rootDir.exists() && !rootDir.mkdirs()) {
            throw new IOException("Could not create directory:" + rootDir.getAbsolutePath());
        }
        this.generateCode(controllers, rootDir);
        this.generateUnreferencedSchemas(resolvedRamlPath, loadRamlFromFile, rootDir);
    }

    private void generateUnreferencedSchemas(String resolvedRamlPath, RamlRoot loadRamlFromFile, File rootDir) {
        if (this.generateUnreferencedSchemas.booleanValue() && loadRamlFromFile.getSchemas() != null && !loadRamlFromFile.getSchemas().isEmpty()) {
            for (Map map : loadRamlFromFile.getSchemas()) {
                for (String schemaName : map.keySet()) {
                    this.getLog().info((CharSequence)("Generating POJO for unreferenced schema " + schemaName));
                    ApiBodyMetadata tempBodyMetadata = SchemaHelper.mapSchemaToPojo((RamlRoot)loadRamlFromFile, (String)schemaName, (String)resolvedRamlPath, (String)schemaName, (String)this.resolvedSchemaLocation);
                    this.generateModelSources(tempBodyMetadata, rootDir, (GenerationConfig)this.generationConfig, (Annotator)(this.useJackson1xCompatibility == true ? new Jackson1Annotator() : null));
                }
            }
        }
    }

    private void generateCode(Set<ApiResourceMetadata> controllers, File rootDir) {
        for (ApiResourceMetadata met : controllers) {
            this.getLog().debug((CharSequence)"");
            this.getLog().debug((CharSequence)"-----------------------------------------------------------");
            this.getLog().debug((CharSequence)met.getName());
            this.getLog().debug((CharSequence)"");
            Set dependencies = met.getDependencies();
            for (ApiBodyMetadata body : dependencies) {
                this.generateModelSources(body, rootDir, (GenerationConfig)this.generationConfig, (Annotator)(this.useJackson1xCompatibility == true ? new Jackson1Annotator() : null));
            }
            this.generateControllerSource(met, rootDir);
        }
    }

    private String getBasePath(RamlRoot loadRamlFromFile) {
        String basePath = loadRamlFromFile.getBaseUri();
        if (this.baseUri != null) {
            basePath = this.baseUri;
        }
        if (basePath != null && basePath.equals("/")) {
            basePath = "";
        }
        return basePath;
    }

    private Rule<JCodeModel, JDefinedClass, ApiResourceMetadata> loadRule() {
        Spring4ControllerStubRule ruleInstance = new Spring4ControllerStubRule();
        try {
            ruleInstance = (Rule)this.getClassRealm().loadClass(this.rule).newInstance();
            this.getLog().debug((CharSequence)StringUtils.collectionToCommaDelimitedString(this.ruleConfiguration.keySet()));
            this.getLog().debug((CharSequence)StringUtils.collectionToCommaDelimitedString(this.ruleConfiguration.values()));
            if (ruleInstance instanceof ConfigurableRule && !CollectionUtils.isEmpty(this.ruleConfiguration)) {
                this.getLog().debug((CharSequence)"SETTING CONFIG");
                ((ConfigurableRule)ruleInstance).applyConfiguration(this.ruleConfiguration);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Could not instantiate Rule " + this.rule + ". The default Rule will be used for code generation."), (Throwable)e);
        }
        return ruleInstance;
    }

    private ClassRealm getClassRealm() throws DependencyResolutionRequiredException, MalformedURLException {
        if (this.classRealm == null) {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            this.classRealm = this.descriptor.getClassRealm();
            if (this.classRealm == null) {
                this.classRealm = this.project.getClassRealm();
            }
            for (String element : runtimeClasspathElements) {
                File elementFile = new File(element);
                this.classRealm.addURL(elementFile.toURI().toURL());
            }
        }
        return this.classRealm;
    }

    private void generateModelSources(ApiBodyMetadata body, File rootDir, GenerationConfig config, Annotator annotator) {
        try {
            JCodeModel codeModel = config == null && annotator == null ? body.getCodeModel() : body.getCodeModel(this.resolvedSchemaLocation, this.basePackage + NamingHelper.getDefaultModelPackage(), config, annotator);
            if (codeModel != null) {
                codeModel.build(rootDir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLog().error((CharSequence)("Could not build code model for " + body.getName()), (Throwable)e);
        }
    }

    private String getSchemaLocation() {
        if (StringUtils.hasText((String)this.schemaLocation)) {
            if (!this.schemaLocation.contains(":")) {
                String resolvedPath = this.project.getBasedir().getAbsolutePath();
                if (resolvedPath.endsWith(File.separator) || resolvedPath.endsWith("/")) {
                    resolvedPath = resolvedPath.substring(0, resolvedPath.length() - 1);
                }
                if (!this.schemaLocation.startsWith(File.separator) && !this.schemaLocation.startsWith("/")) {
                    resolvedPath = resolvedPath + File.separator;
                }
                resolvedPath = resolvedPath + this.schemaLocation;
                if (!this.schemaLocation.endsWith(File.separator) && !this.schemaLocation.endsWith("/")) {
                    resolvedPath = resolvedPath + File.separator;
                }
                resolvedPath = resolvedPath.replace(File.separator, "/").replace("\\", "/");
                try {
                    URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                    Class<URLClassLoader> urlClass = URLClassLoader.class;
                    Method method = urlClass.getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke((Object)urlClassLoader, new File(resolvedPath).toURI().toURL());
                    return "classpath:/";
                }
                catch (Exception ex) {
                    this.getLog().error((CharSequence)"Could not add schema location to classpath", (Throwable)ex);
                    return new File(resolvedPath).toURI().toString();
                }
            }
            return this.schemaLocation;
        }
        return null;
    }

    private void generateControllerSource(ApiResourceMetadata met, File dir) {
        JCodeModel codeModel = new JCodeModel();
        this.loadRule().apply((Object)met, (Object)codeModel);
        try {
            codeModel.build(dir);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLog().error((CharSequence)("Could not build code model for " + met.getName()), (Throwable)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        try {
            this.generateEndpoints();
        }
        catch (IOException e) {
            ClassLoaderUtils.restoreOriginalClassLoader();
            throw new MojoExecutionException((Object)e, "Unexpected exception while executing Spring MVC Endpoint Generation Plugin.", e.toString());
        }
        this.getLog().info((CharSequence)("Endpoint Generation Complete in:" + (System.currentTimeMillis() - startTime) + "ms"));
    }
}

