/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.plugin;

import com.phoenixnap.oss.ramlapisync.generation.RamlGenerator;
import com.phoenixnap.oss.ramlapisync.generation.RamlVerifier;
import com.phoenixnap.oss.ramlapisync.parser.ResourceParser;
import com.phoenixnap.oss.ramlapisync.parser.SpringMvcResourceParser;
import com.phoenixnap.oss.ramlapisync.plugin.ClassLoaderUtils;
import com.phoenixnap.oss.ramlapisync.plugin.CommonApiSyncMojo;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.phoenixnap.oss.ramlapisync.style.checkers.ActionSecurityResponseChecker;
import com.phoenixnap.oss.ramlapisync.style.checkers.RequestBodySchemaStyleChecker;
import com.phoenixnap.oss.ramlapisync.style.checkers.ResourceCollectionPluralisationChecker;
import com.phoenixnap.oss.ramlapisync.style.checkers.ResourceUrlStyleChecker;
import com.phoenixnap.oss.ramlapisync.style.checkers.ResponseBodySchemaStyleChecker;
import com.phoenixnap.oss.ramlapisync.style.checkers.ResponseCodeDefinitionStyleChecker;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.checkers.ActionContentTypeChecker;
import com.phoenixnap.oss.ramlapisync.verification.checkers.ActionExistenceChecker;
import com.phoenixnap.oss.ramlapisync.verification.checkers.ActionQueryParameterChecker;
import com.phoenixnap.oss.ramlapisync.verification.checkers.ActionResponseBodySchemaChecker;
import com.phoenixnap.oss.ramlapisync.verification.checkers.ResourceExistenceChecker;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RestController;

@Mojo(name="verify-springmvc-api-docs", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class SpringMvcRamlVerifierMojo
extends CommonApiSyncMojo {
    @Parameter(required=true, readonly=true, defaultValue="")
    protected String ramlToVerifyPath;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean checkRamlAgainstImplementation;
    @Parameter(required=false, readonly=true, defaultValue="")
    protected String uriPrefixToIgnore;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean performStyleChecks;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean checkForResourceExistence;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean checkForActionExistence;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean checkForActionContentType;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean checkForQueryParameterExistence;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean checkForPluralisedResourceNames;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean checkForSpecialCharactersInResourceNames;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean checkForDefinitionOf40xResponseInSecuredResource;
    @Parameter(required=false, readonly=true, defaultValue="")
    protected String checkForSchemaInSuccessfulResponseBody;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean checkForDefinitionOfErrorCodes;
    @Parameter(required=false, readonly=true, defaultValue="")
    protected String checkForSchemaInRequestBody;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean checkForDefinitionOf404ResponseInGetRequest;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean checkForResponseBodySchema;
    @Parameter(required=false, readonly=true, defaultValue="false")
    protected Boolean breakBuildOnWarnings;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean logWarnings;
    @Parameter(required=false, readonly=true, defaultValue="true")
    protected Boolean logErrors;

    @Override
    protected Class<? extends Annotation>[] getSupportedClassAnnotations() {
        return new Class[]{Controller.class, RestController.class};
    }

    protected void verifyRaml() throws MojoExecutionException, MojoFailureException, IOException {
        RamlVerifier verifier;
        super.prepareRaml();
        Class[] classArray = new Class[this.annotatedClasses.size()];
        classArray = this.annotatedClasses.toArray(classArray);
        File targetPath = StringUtils.hasText((String)this.javaDocPath) ? new File(this.javaDocPath) : (this.project.getBasedir().getParentFile() != null ? this.project.getBasedir().getParentFile() : this.project.getBasedir());
        ArrayList<ResourceExistenceChecker> checkers = new ArrayList<ResourceExistenceChecker>();
        ArrayList<Object> actionCheckers = new ArrayList<Object>();
        ArrayList<ActionExistenceChecker> resourceCheckers = new ArrayList<ActionExistenceChecker>();
        RamlRoot implementedRaml = null;
        if (this.checkRamlAgainstImplementation.booleanValue()) {
            SpringMvcResourceParser scanner = new SpringMvcResourceParser(targetPath, this.version, "application/everything", false);
            RamlGenerator ramlGenerator = new RamlGenerator((ResourceParser)scanner);
            ramlGenerator.generateRamlForClasses(this.project.getArtifactId(), this.version, "/", classArray, this.documents);
            implementedRaml = ramlGenerator.getRaml();
            if (this.checkForResourceExistence.booleanValue()) {
                checkers.add(new ResourceExistenceChecker());
            }
            if (this.checkForActionExistence.booleanValue()) {
                resourceCheckers.add(new ActionExistenceChecker());
            }
            if (this.checkForQueryParameterExistence.booleanValue()) {
                actionCheckers.add(new ActionQueryParameterChecker());
            }
            if (this.checkForActionContentType.booleanValue()) {
                actionCheckers.add(new ActionContentTypeChecker());
            }
            if (this.checkForResponseBodySchema.booleanValue()) {
                actionCheckers.add(new ActionResponseBodySchemaChecker());
            }
        }
        ArrayList<Object> styleCheckers = new ArrayList<Object>();
        if (this.performStyleChecks.booleanValue()) {
            if (this.checkForPluralisedResourceNames.booleanValue()) {
                styleCheckers.add(new ResourceCollectionPluralisationChecker());
            }
            if (this.checkForDefinitionOf40xResponseInSecuredResource.booleanValue()) {
                styleCheckers.add(new ActionSecurityResponseChecker());
            }
            if (this.checkForSpecialCharactersInResourceNames.booleanValue()) {
                styleCheckers.add(new ResourceUrlStyleChecker());
            }
            if (StringUtils.hasText((String)this.checkForSchemaInRequestBody)) {
                styleCheckers.add(new RequestBodySchemaStyleChecker(this.checkForSchemaInRequestBody));
            }
            if (StringUtils.hasText((String)this.checkForSchemaInSuccessfulResponseBody)) {
                styleCheckers.add(new ResponseBodySchemaStyleChecker(this.checkForSchemaInSuccessfulResponseBody));
            }
            LinkedMultiValueMap statusChecks = new LinkedMultiValueMap();
            if (this.checkForDefinitionOf404ResponseInGetRequest.booleanValue()) {
                statusChecks.add((Object)HttpMethod.GET.name(), (Object)HttpStatus.NOT_FOUND);
            }
            if (this.checkForDefinitionOfErrorCodes.booleanValue()) {
                statusChecks.add((Object)HttpMethod.PUT.name(), (Object)HttpStatus.BAD_REQUEST);
                statusChecks.add((Object)HttpMethod.POST.name(), (Object)HttpStatus.BAD_REQUEST);
                statusChecks.add((Object)HttpMethod.PATCH.name(), (Object)HttpStatus.BAD_REQUEST);
                statusChecks.add((Object)HttpMethod.GET.name(), (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                statusChecks.add((Object)HttpMethod.PATCH.name(), (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                statusChecks.add((Object)HttpMethod.PUT.name(), (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                statusChecks.add((Object)HttpMethod.POST.name(), (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                statusChecks.add((Object)HttpMethod.DELETE.name(), (Object)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (!statusChecks.isEmpty()) {
                styleCheckers.add(new ResponseCodeDefinitionStyleChecker((MultiValueMap)statusChecks));
            }
        }
        if ((verifier = new RamlVerifier(RamlVerifier.loadRamlFromFile((String)this.ramlToVerifyPath), implementedRaml, checkers, actionCheckers, resourceCheckers, styleCheckers, StringUtils.hasText((String)this.uriPrefixToIgnore) ? this.uriPrefixToIgnore : null)).hasWarnings() && this.logWarnings.booleanValue()) {
            for (Issue issue : verifier.getWarnings()) {
                this.getLog().warn((CharSequence)issue.toString());
            }
        }
        if (verifier.hasErrors()) {
            if (this.logErrors.booleanValue()) {
                for (Issue issue : verifier.getErrors()) {
                    this.getLog().error((CharSequence)issue.toString());
                }
            }
            throw new IllegalStateException("Errors found when comparing RAML to Spring MVC Implementation");
        }
        if (verifier.hasWarnings() && this.breakBuildOnWarnings.booleanValue()) {
            throw new IllegalStateException("Warnings found when comparing RAML to Spring MVC Implementation and build is set to break on Warnings");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)("Skipping [pom] project: " + this.project.getName()));
        } else if (this.project.getPackaging().equals("maven-plugin")) {
            this.getLog().info((CharSequence)("Skipping [maven-plugin] project: " + this.project.getName()));
        } else if (!Files.isDirectory(Paths.get(this.project.getBuild().getSourceDirectory(), new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            this.getLog().info((CharSequence)("Skipping project with missing src folder: " + this.project.getName()));
        } else {
            try {
                this.verifyRaml();
            }
            catch (IOException e) {
                ClassLoaderUtils.restoreOriginalClassLoader();
                throw new MojoExecutionException((Object)e, "Unexpected exception while executing Raml Sync Plugin.", e.toString());
            }
        }
        this.getLog().info((CharSequence)("Raml Verification Complete in:" + (System.currentTimeMillis() - startTime) + "ms"));
    }
}

