/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.Distinct;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Generators;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.internal.Lists;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Sequences;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ArrayGenerator
extends Generator<Object> {
    private final Class<?> componentType;
    private final Generator<?> component;
    private Size lengthRange;
    private boolean distinct;

    ArrayGenerator(Class<?> componentType, Generator<?> component) {
        super(Object.class);
        this.componentType = componentType;
        this.component = component;
    }

    public void configure(Size size) {
        this.lengthRange = size;
        Ranges.checkRange(Ranges.Type.INTEGRAL, size.min(), size.max());
    }

    public void configure(Distinct distinct) {
        this.distinct = distinct != null;
    }

    @Override
    public Object generate(SourceOfRandomness random, GenerationStatus status) {
        int length = this.length(random, status);
        Object array = Array.newInstance(this.componentType, length);
        Stream items = (Stream)Stream.generate(() -> this.component.generate(random, status)).sequential();
        if (this.distinct) {
            items = items.distinct();
        }
        Iterator iterator = items.iterator();
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, iterator.next());
        }
        return array;
    }

    @Override
    public boolean canShrink(Object larger) {
        return larger.getClass().getComponentType() == this.componentType;
    }

    @Override
    public List<Object> doShrink(SourceOfRandomness random, Object larger) {
        int length = Array.getLength(larger);
        ArrayList<Object> asList = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            asList.add(Array.get(larger, i));
        }
        ArrayList<Object> shrinks = new ArrayList<Object>(this.removals(asList));
        Stream<Object> oneItemShrinks = Lists.shrinksOfOneItem(random, asList, this.component).stream();
        if (this.distinct) {
            oneItemShrinks = oneItemShrinks.filter(Lists::isDistinct);
        }
        shrinks.addAll(oneItemShrinks.map(this::convert).filter(this::inLengthRange).collect(Collectors.toList()));
        return shrinks;
    }

    @Override
    public void provide(Generators provided) {
        super.provide(provided);
        this.component.provide(provided);
    }

    @Override
    public BigDecimal magnitude(Object value) {
        int length = Array.getLength(value);
        if (length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal elementsMagnitude = IntStream.range(0, length).mapToObj(i -> this.component.magnitude(Array.get(value, i))).reduce(BigDecimal.ZERO, BigDecimal::add);
        return BigDecimal.valueOf(length).multiply(elementsMagnitude);
    }

    @Override
    public void configure(AnnotatedType annotatedType) {
        super.configure(annotatedType);
        List<AnnotatedType> annotated = Reflection.annotatedComponentTypes(annotatedType);
        if (!annotated.isEmpty()) {
            this.component.configure(annotated.get(0));
        }
    }

    private int length(SourceOfRandomness random, GenerationStatus status) {
        return this.lengthRange != null ? random.nextInt(this.lengthRange.min(), this.lengthRange.max()) : status.size();
    }

    private boolean inLengthRange(Object items) {
        int length = Array.getLength(items);
        return this.lengthRange == null || length >= this.lengthRange.min() && length <= this.lengthRange.max();
    }

    private List<Object> removals(List<?> items) {
        return StreamSupport.stream(Sequences.halving(items.size()).spliterator(), false).map((? super T i) -> Lists.removeFrom(items, i)).flatMap(Collection::stream).map(this::convert).filter(this::inLengthRange).collect(Collectors.toList());
    }

    private Object convert(List<?> items) {
        Object array = Array.newInstance(this.componentType, items.size());
        for (int i = 0; i < items.size(); ++i) {
            Array.set(array, i, items.get(i));
        }
        return array;
    }
}

