/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.ComponentizedGenerator;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Shrink;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.internal.Lists;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Sequences;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public abstract class MapGenerator<T extends Map>
extends ComponentizedGenerator<T> {
    private Size sizeRange;

    protected MapGenerator(Class<T> type) {
        super(type);
    }

    public void configure(Size size) {
        this.sizeRange = size;
        Ranges.checkRange((Ranges.Type)Ranges.Type.INTEGRAL, (Comparable)Integer.valueOf(size.min()), (Comparable)Integer.valueOf(size.max()));
    }

    public T generate(SourceOfRandomness random, GenerationStatus status) {
        int size = this.size(random, status);
        T items = this.empty();
        for (int i = 0; i < size; ++i) {
            Object value;
            Object key = ((Generator)this.componentGenerators().get(0)).generate(random, status);
            if (!this.okToAdd(key, value = ((Generator)this.componentGenerators().get(1)).generate(random, status))) continue;
            items.put((Object)key, (Object)value);
        }
        return items;
    }

    public List<T> doShrink(SourceOfRandomness random, T larger) {
        ArrayList entries = new ArrayList(larger.entrySet());
        ArrayList<T> shrinks = new ArrayList<T>();
        shrinks.addAll(this.removals(entries));
        Shrink<Map.Entry<?, ?>> entryShrink = this.entryShrinker((Shrink<Object>)((Shrink)this.componentGenerators().get(0)), (Shrink<Object>)((Shrink)this.componentGenerators().get(1)));
        List oneEntryShrinks = Lists.shrinksOfOneItem((SourceOfRandomness)random, entries, entryShrink);
        shrinks.addAll(oneEntryShrinks.stream().map(this::convert).filter(this::inSizeRange).collect(Collectors.toList()));
        return shrinks;
    }

    public int numberOfNeededComponents() {
        return 2;
    }

    protected final T empty() {
        return (T)((Map)Reflection.instantiate((Constructor)Reflection.findConstructor((Class)((Class)this.types().get(0)), (Class[])new Class[0]), (Object[])new Object[0]));
    }

    protected boolean okToAdd(Object key, Object value) {
        return true;
    }

    private boolean inSizeRange(T target) {
        return this.sizeRange == null || target.size() >= this.sizeRange.min() && target.size() <= this.sizeRange.max();
    }

    private int size(SourceOfRandomness random, GenerationStatus status) {
        return this.sizeRange != null ? random.nextInt(this.sizeRange.min(), this.sizeRange.max()) : status.size();
    }

    private List<T> removals(List<Map.Entry<?, ?>> items) {
        return StreamSupport.stream(Sequences.halving((int)items.size()).spliterator(), false).map(i -> Lists.removeFrom((List)items, (int)i)).flatMap(Collection::stream).map(this::convert).filter(this::inSizeRange).collect(Collectors.toList());
    }

    private T convert(List<?> entries) {
        T converted = this.empty();
        for (Object each : entries) {
            Map.Entry entry = (Map.Entry)each;
            converted.put(entry.getKey(), entry.getValue());
        }
        return converted;
    }

    private Shrink<Map.Entry<?, ?>> entryShrinker(Shrink<Object> keyShrinker, Shrink<Object> valueShrinker) {
        return (r, e) -> {
            Map.Entry entry = (Map.Entry)e;
            List keyShrinks = keyShrinker.shrink(r, entry.getKey());
            List valueShrinks = valueShrinker.shrink(r, entry.getValue());
            ArrayList shrinks = new ArrayList();
            shrinks.addAll(IntStream.range(0, keyShrinks.size()).mapToObj(i -> new AbstractMap.SimpleEntry(keyShrinks.get(i), entry.getValue())).collect(Collectors.toList()));
            shrinks.addAll(IntStream.range(0, valueShrinks.size()).mapToObj(i -> new AbstractMap.SimpleEntry(entry.getKey(), valueShrinks.get(i))).collect(Collectors.toList()));
            return shrinks;
        };
    }
}

