/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.ComponentizedGenerator;
import com.pholser.junit.quickcheck.generator.Distinct;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Shrink;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.internal.Lists;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Sequences;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class CollectionGenerator<T extends Collection>
extends ComponentizedGenerator<T> {
    private Size sizeRange;
    private boolean distinct;

    protected CollectionGenerator(Class<T> type) {
        super(type);
    }

    public void configure(Size size) {
        this.sizeRange = size;
        Ranges.checkRange((Ranges.Type)Ranges.Type.INTEGRAL, (Comparable)Integer.valueOf(size.min()), (Comparable)Integer.valueOf(size.max()));
    }

    public void configure(Distinct distinct) {
        this.distinct = distinct != null;
    }

    public T generate(SourceOfRandomness random, GenerationStatus status) {
        int size = this.size(random, status);
        Generator generator = (Generator)this.componentGenerators().get(0);
        Stream itemStream = (Stream)Stream.generate(() -> generator.generate(random, status)).sequential();
        if (this.distinct) {
            itemStream = itemStream.distinct();
        }
        T items = this.empty();
        itemStream.limit(size).forEach(arg_0 -> items.add(arg_0));
        return items;
    }

    public List<T> doShrink(SourceOfRandomness random, T larger) {
        ArrayList asList = new ArrayList(larger);
        ArrayList<T> shrinks = new ArrayList<T>(this.removals(asList));
        Shrink generator = (Shrink)this.componentGenerators().get(0);
        Stream<Object> oneItemShrinks = Lists.shrinksOfOneItem((SourceOfRandomness)random, asList, (Shrink)generator).stream();
        if (this.distinct) {
            oneItemShrinks = oneItemShrinks.filter(Lists::isDistinct);
        }
        shrinks.addAll(oneItemShrinks.map(this::convert).filter(this::inSizeRange).collect(Collectors.toList()));
        return shrinks;
    }

    public int numberOfNeededComponents() {
        return 1;
    }

    public BigDecimal magnitude(Object value) {
        Collection narrowed = (Collection)this.narrow(value);
        if (narrowed.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal elementsMagnitude = narrowed.stream().map(e -> ((Generator)this.componentGenerators().get(0)).magnitude(e)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return BigDecimal.valueOf(narrowed.size()).multiply(elementsMagnitude);
    }

    protected final T empty() {
        return (T)((Collection)Reflection.instantiate((Constructor)Reflection.findConstructor((Class)((Class)this.types().get(0)), (Class[])new Class[0]), (Object[])new Object[0]));
    }

    private boolean inSizeRange(T items) {
        return this.sizeRange == null || items.size() >= this.sizeRange.min() && items.size() <= this.sizeRange.max();
    }

    private int size(SourceOfRandomness random, GenerationStatus status) {
        return this.sizeRange != null ? random.nextInt(this.sizeRange.min(), this.sizeRange.max()) : status.size();
    }

    private List<T> removals(List<?> items) {
        return StreamSupport.stream(Sequences.halving((int)items.size()).spliterator(), false).map(i -> Lists.removeFrom((List)items, (int)i)).flatMap(Collection::stream).map(this::convert).filter(this::inSizeRange).collect(Collectors.toList());
    }

    private T convert(List<?> items) {
        T converted = this.empty();
        converted.addAll(items);
        return converted;
    }
}

