/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class SwiftBlock4
extends SwiftTagListBlock
implements Serializable {
    private static final long serialVersionUID = -623730182521597955L;

    public SwiftBlock4() {
    }

    public SwiftBlock4(List<Tag> tags) {
        Objects.requireNonNull(tags, "parameter 'tags' cannot be null");
        this.addTags(tags);
    }

    public static SwiftBlock4 removeEmptySequences(SwiftBlock4 b4) {
        if (b4 == null) {
            return null;
        }
        Stack<Tag> stack = new Stack<Tag>();
        for (Tag t : b4.getTags()) {
            if (!stack.isEmpty() && StringUtils.equals((CharSequence)t.getName(), (CharSequence)"16S") && StringUtils.equals((CharSequence)((Tag)stack.peek()).getName(), (CharSequence)"16R") && StringUtils.equals((CharSequence)((Tag)stack.peek()).getValue(), (CharSequence)t.getValue())) {
                stack.pop();
                continue;
            }
            if (t.isNumber(15) && !stack.isEmpty() && ((Tag)stack.peek()).isNumber(15)) {
                stack.pop();
                stack.push(t);
                continue;
            }
            stack.push(t);
        }
        if (!stack.isEmpty() && ((Tag)stack.peek()).isNumber(15)) {
            stack.pop();
        }
        return new SwiftBlock4(new ArrayList<Tag>(stack));
    }

    public static SwiftBlock4 fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (SwiftBlock4)gson.fromJson(json, SwiftBlock4.class);
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
        Objects.requireNonNull(blockNumber, "parameter 'blockNumber' cannot be null");
        Validate.isTrue((blockNumber == 4 ? 1 : 0) != 0, (String)"blockNumber must be 4", (Object[])new Object[0]);
    }

    @Override
    protected void setBlockName(String blockName) {
        Objects.requireNonNull(blockName, "parameter 'blockName' cannot be null");
        Validate.isTrue((blockName.compareTo("4") == 0 ? 1 : 0) != 0, (String)"blockName must be string '4'", (Object[])new Object[0]);
    }

    @Override
    public Integer getNumber() {
        return 4;
    }

    @Override
    public String getName() {
        return "4";
    }
}

