/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field405;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT015
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT015.class.getName());
    public static final String NAME = "015";

    public MT015(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT015(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT015 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT015(m);
    }

    public MT015() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT015(String sender, String receiver) {
        super(15, sender, receiver);
    }

    public MT015(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT015.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT015 object from FIN content with a Service Message. Check if the MT015 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT015 object from FIN content with message type " + param.getType());
        }
    }

    public static MT015 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT015(fin);
    }

    public MT015(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT015 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT015(stream);
    }

    public MT015(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT015 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT015(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT015 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT015 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT015 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT015 fromJson(String json) {
        return (MT015)AbstractMT.fromJson(json);
    }

    public Field405 getField405() {
        Tag t = this.tag("405");
        if (t != null) {
            return new Field405(t.getValue());
        }
        return null;
    }
}

