/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class OptionUPartyField
extends Field {
    public static final String PARSER_PATTERN = ":S//S[$S]0-2";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSS";
    public static final String TYPES_PATTERN = "SSSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer PARTY_NAME = 2;

    public OptionUPartyField() {
        super(4);
    }

    public OptionUPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(4);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent(1, SwiftParseUtils.getTokenFirst(lines.get(0), ":", "//"));
            this.setComponent(2, SwiftParseUtils.getTokenSecond(lines.get(0), "//"));
        }
        SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.appendInLines(result, 3, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        DeprecationUtils.phase2(this.getClass(), "componentsPattern()", "Use typesPattern() instead.");
        return this.typesPattern();
    }

    @Override
    public final String typesPattern() {
        return "SSSS";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Party Name");
        result.add("Party Name 2");
        result.add("Party Name 3");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "partyName");
        result.put(3, "partyName2");
        result.put(4, "partyName3");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("partyname", 2);
        this.labelMap.put("partyname2", 3);
        this.labelMap.put("partyname3", 4);
        return this.labelMap;
    }

    @Override
    public abstract String getName();

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getPartyNameLine1() {
        return this.getComponent(2);
    }

    public String getPartyNameLine2() {
        return this.getComponent(3);
    }

    public String getPartyNameLine3() {
        return this.getComponent(4);
    }

    public String getPartyName() {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 5; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }
}

