/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field202;
import com.prowidesoftware.swift.model.field.Field203;
import com.prowidesoftware.swift.model.field.Field305;
import com.prowidesoftware.swift.model.field.Field331;
import com.prowidesoftware.swift.model.field.Field332;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT081
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT081.class.getName());
    public static final String NAME = "081";

    public MT081(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT081(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT081 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT081(m);
    }

    public MT081() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT081(String sender, String receiver) {
        super(81, sender, receiver);
    }

    public MT081(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT081.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT081 object from FIN content with a Service Message. Check if the MT081 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT081 object from FIN content with message type " + param.getType());
        }
    }

    public static MT081 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT081(fin);
    }

    public MT081(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT081 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT081(stream);
    }

    public MT081(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT081 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT081(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT081 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT081 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT081 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT081 fromJson(String json) {
        return (MT081)AbstractMT.fromJson(json);
    }

    public Field202 getField202() {
        Tag t = this.tag("202");
        if (t != null) {
            return new Field202(t.getValue());
        }
        return null;
    }

    public Field203 getField203() {
        Tag t = this.tag("203");
        if (t != null) {
            return new Field203(t.getValue());
        }
        return null;
    }

    public List<Field305> getField305() {
        ArrayList<Field305> result = new ArrayList<Field305>();
        Tag[] tags = this.tags("305");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field305(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field331> getField331() {
        ArrayList<Field331> result = new ArrayList<Field331>();
        Tag[] tags = this.tags("331");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field331(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field332> getField332() {
        ArrayList<Field332> result = new ArrayList<Field332>();
        Tag[] tags = this.tags("332");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field332(tag.getValue()));
            }
        }
        return result;
    }
}

