/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt8xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field28;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field54A;
import com.prowidesoftware.swift.model.field.Field54B;
import com.prowidesoftware.swift.model.field.Field54D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT802
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT802.class.getName());
    public static final String NAME = "802";

    public MT802(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT802(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT802 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT802(m);
    }

    public MT802() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT802(String sender, String receiver) {
        super(802, sender, receiver);
    }

    public MT802(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT802.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT802 object from FIN content with a Service Message. Check if the MT802 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT802 object from FIN content with message type " + param.getType());
        }
    }

    public static MT802 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT802(fin);
    }

    public MT802(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT802 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT802(stream);
    }

    public MT802(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT802 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT802(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT802 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT802 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT802 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT802 fromJson(String json) {
        return (MT802)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field28 getField28() {
        Tag t = this.tag("28");
        if (t != null) {
            return new Field28(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public Field53D getField53D() {
        Tag t = this.tag("53D");
        if (t != null) {
            return new Field53D(t.getValue());
        }
        return null;
    }

    public Field54A getField54A() {
        Tag t = this.tag("54A");
        if (t != null) {
            return new Field54A(t.getValue());
        }
        return null;
    }

    public Field54B getField54B() {
        Tag t = this.tag("54B");
        if (t != null) {
            return new Field54B(t.getValue());
        }
        return null;
    }

    public Field54D getField54D() {
        Tag t = this.tag("54D");
        if (t != null) {
            return new Field54D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

