/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field37H;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT935
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT935.class.getName());
    public static final String NAME = "935";

    public MT935(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT935(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT935 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT935(m);
    }

    public MT935() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT935(String sender, String receiver) {
        super(935, sender, receiver);
    }

    public MT935(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT935.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT935 object from FIN content with a Service Message. Check if the MT935 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT935 object from FIN content with message type " + param.getType());
        }
    }

    public static MT935 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT935(fin);
    }

    public MT935(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT935 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT935(stream);
    }

    public MT935(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT935 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT935(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT935 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT935 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT935 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT935 fromJson(String json) {
        return (MT935)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field23> getField23() {
        ArrayList<Field23> result = new ArrayList<Field23>();
        Tag[] tags = this.tags("23");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field23(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field25> getField25() {
        ArrayList<Field25> result = new ArrayList<Field25>();
        Tag[] tags = this.tags("25");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field25(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field30> getField30() {
        ArrayList<Field30> result = new ArrayList<Field30>();
        Tag[] tags = this.tags("30");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field30(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field37H> getField37H() {
        ArrayList<Field37H> result = new ArrayList<Field37H>();
        Tag[] tags = this.tags("37H");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field37H(tag.getValue()));
            }
        }
        return result;
    }
}

