/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field97E
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "97E";
    public static final String F_97E = "97E";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SS";
    @Deprecated
    public static final String TYPES_PATTERN = "SS";
    public static final Integer QUALIFIER = 1;
    public static final Integer INTERNATIONAL_BANK_ACCOUNT_NUMBER = 2;
    @Deprecated
    public static final Integer ACCOUNT = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field97E() {
        super(2);
    }

    public Field97E(String value) {
        super(value);
    }

    public Field97E(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"97E")) {
            throw new IllegalArgumentException("cannot create field 97E from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field97E newInstance(Field97E source) {
        Field97E cp = new Field97E();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("97E", value);
    }

    public static Tag emptyTag() {
        return new Tag("97E", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 97E");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SS";
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//34x";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("International Bank Account Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "internationalBankAccountNumber");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("internationalbankaccountnumber", 2);
        this.labelMap.put("account", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getInternationalBankAccountNumber() {
        String account = this.getComponent(2);
        if (account != null) {
            for (int i = 0; i < account.length(); ++i) {
                if (account.charAt(i) == '/') continue;
                return account.substring(i);
            }
            return "";
        }
        return null;
    }

    @Deprecated
    public String getAccount() {
        return this.getInternationalBankAccountNumber();
    }

    public Field97E setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field97E setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field97E setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field97E setInternationalBankAccountNumber(String component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field97E setAccount(String component2) {
        return this.setInternationalBankAccountNumber(component2);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "97E";
    }

    public static Field97E get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("97E");
        if (t == null) {
            return null;
        }
        return new Field97E(t);
    }

    public static Field97E get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field97E.get(msg.getBlock4());
    }

    public static List<Field97E> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field97E.getAll(msg.getBlock4());
    }

    public static List<Field97E> getAll(SwiftTagListBlock block) {
        ArrayList<Field97E> result = new ArrayList<Field97E>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("97E");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field97E(f));
            }
        }
        return result;
    }

    public static Field97E fromJson(String json) {
        Field97E field = new Field97E();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("account") != null) {
            field.setComponent2(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("internationalBankAccountNumber") != null) {
            field.setComponent2(jsonObject.get("internationalBankAccountNumber").getAsString());
        }
        return field;
    }
}

