/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import org.apache.commons.lang3.StringUtils;

public enum ServiceIdType {
    _01("GPA/FIN Message (system and user-to-user)"),
    _02("GPA Login"),
    _03("GPA Select"),
    _05("FIN Quit"),
    _06("GPA Logout"),
    _12("GPA System Remove AP Request"),
    _13("GPA System Abort AP Confirmation"),
    _14("GPA System Remove LT Request"),
    _15("GPA System Abort LT Confirmation"),
    _21("GPA/FIN Message (ACK/NAK/UAK/UNK)"),
    _22("GPA Login ACK (LAK)"),
    _23("GPA Select ACK (SAK)"),
    _25("FIN Quit ACK"),
    _26("GPA Logout ACK"),
    _33("GPA User Abort AP Request"),
    _35("GPA User Abort LT Request"),
    _42("GPA Login NAK (LNK)"),
    _43("GPA Select NAK (SNK)");

    private final String description;

    private ServiceIdType(String description) {
        this.description = description;
    }

    public static boolean valid(String number) {
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            try {
                ServiceIdType.valueOf("_" + number);
                return true;
            }
            catch (Exception unused) {
                return false;
            }
        }
        return false;
    }

    public String description() {
        return this.number() + " - " + this.description;
    }

    public final String number() {
        return this.name().substring(1);
    }
}

