/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field90K
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90K";
    public static final String F_90K = "90K";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//N";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SN";
    @Deprecated
    public static final String TYPES_PATTERN = "SI";
    public static final Integer QUALIFIER = 1;
    public static final Integer INDEX_POINTS = 2;
    @Deprecated
    public static final Integer AMOUNT = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field90K() {
        super(2);
    }

    public Field90K(String value) {
        super(value);
    }

    public Field90K(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"90K")) {
            throw new IllegalArgumentException("cannot create field 90K from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field90K newInstance(Field90K source) {
        Field90K cp = new Field90K();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("90K", value);
    }

    public static Tag emptyTag() {
        return new Tag("90K", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 90K");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent2AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Index Points");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "indexPoints");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("indexpoints", 2);
        this.labelMap.put("amount", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        return this.getComponent2AsBigDecimal();
    }

    public String getIndexPoints() {
        return this.getComponent2();
    }

    @Deprecated
    public String getAmount() {
        return this.getIndexPoints();
    }

    public BigDecimal getIndexPointsAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    @Deprecated
    public Number getIndexPointsAsNumber() {
        return this.getComponent2AsNumber();
    }

    @Deprecated
    public BigDecimal getAmountAsBigDecimal() {
        return this.getIndexPointsAsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getIndexPointsAsNumber();
    }

    public Field90K setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90K setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field90K setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90K setComponent2(BigDecimal component2) {
        this.setComponent(2, SwiftFormatUtils.getBigDecimal(component2));
        return this;
    }

    public Field90K setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field90K setIndexPoints(String component2) {
        return this.setComponent2(component2);
    }

    public Field90K setIndexPoints(BigDecimal component2) {
        return this.setComponent2(component2);
    }

    public Field90K setIndexPoints(Number component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field90K setAmount(String component2) {
        return this.setIndexPoints(component2);
    }

    @Deprecated
    public Field90K setAmount(BigDecimal component2) {
        return this.setIndexPoints(component2);
    }

    @Deprecated
    public Field90K setAmount(Number component2) {
        return this.setIndexPoints(component2);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "90K";
    }

    public static Field90K get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("90K");
        if (t == null) {
            return null;
        }
        return new Field90K(t);
    }

    public static Field90K get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field90K.get(msg.getBlock4());
    }

    public static List<Field90K> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field90K.getAll(msg.getBlock4());
    }

    public static List<Field90K> getAll(SwiftTagListBlock block) {
        ArrayList<Field90K> result = new ArrayList<Field90K>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("90K");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field90K(f));
            }
        }
        return result;
    }

    public static Field90K fromJson(String json) {
        Field90K field = new Field90K();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("indexPoints") != null) {
            field.setComponent2(jsonObject.get("indexPoints").getAsString());
        }
        return field;
    }
}

