/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.PartyIdentifier;
import com.prowidesoftware.swift.model.field.PartyIdentifierUtils;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class OptionDPartyField
extends Field
implements PartyIdentifier {
    public static final String PARSER_PATTERN = "[[/c][/S]$]S[$S]0-3";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSSSS";
    public static final String TYPES_PATTERN = "SSSSSS";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer NAME_AND_ADDRESS = 3;

    public OptionDPartyField() {
        super(6);
    }

    public OptionDPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(6);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            String party = lines.get(0);
            if (StringUtils.startsWith((CharSequence)party, (CharSequence)"/C/") || StringUtils.startsWith((CharSequence)party, (CharSequence)"/D/")) {
                this.setComponent(1, String.valueOf(party.charAt(1)));
                this.setComponent(2, StringUtils.substring((String)party, (int)3));
            } else {
                this.setComponent(2, StringUtils.substring((String)party, (int)1));
            }
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
        } else {
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 0, lines);
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        this.appendInLines(result, 3, 6);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        DeprecationUtils.phase3(this.getClass(), "componentsPattern()", "Use typesPattern() instead.");
        return this.typesPattern();
    }

    @Override
    public final String typesPattern() {
        return "SSSSSS";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 2) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("Name And Address");
        result.add("Name And Address 2");
        result.add("Name And Address 3");
        result.add("Name And Address 4");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dCMark");
        result.put(2, "account");
        result.put(3, "nameAndAddress");
        result.put(4, "nameAndAddress2");
        result.put(5, "nameAndAddress3");
        result.put(6, "nameAndAddress4");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("dcmark", 1);
        this.labelMap.put("account", 2);
        this.labelMap.put("nameandaddress", 3);
        this.labelMap.put("nameandaddress2", 4);
        this.labelMap.put("nameandaddress3", 5);
        this.labelMap.put("nameandaddress4", 6);
        return this.labelMap;
    }

    @Override
    public abstract String getName();

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine1() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine2() {
        return this.getComponent(4);
    }

    public String getNameAndAddressLine3() {
        return this.getComponent(5);
    }

    public String getNameAndAddressLine4() {
        return this.getComponent(6);
    }

    public String getNameAndAddress() {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < 7; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Override
    public String getPartyIdentifier() {
        return PartyIdentifierUtils.getPartyIdentifier(this, 1, 2);
    }

    @Override
    public OptionDPartyField setPartyIdentifier(String partyIdentifier) {
        return (OptionDPartyField)PartyIdentifierUtils.setPartyIdentifier(this, 1, 2, partyIdentifier);
    }
}

