/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.prowidesoftware.swift.model.MtId;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field108;
import com.prowidesoftware.swift.model.field.Field177;
import com.prowidesoftware.swift.model.field.Field405;
import com.prowidesoftware.swift.model.field.Field451;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.Validate;

public class ServiceMessage21
extends AbstractMT {
    public ServiceMessage21(SwiftMessage aMessage) {
        super(aMessage);
        Validate.isTrue((boolean)aMessage.isServiceMessage21());
    }

    public ServiceMessage21(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public ServiceMessage21(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public ServiceMessage21(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = ServiceMessage21.read(fin)) != null) {
            this.m = parsed;
            Validate.isTrue((boolean)parsed.isServiceMessage21());
        }
    }

    public static AbstractMT newInstance(SwiftMessage swiftMessage) {
        return new ServiceMessage21(swiftMessage);
    }

    public static ServiceMessage21 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new ServiceMessage21(m.message());
    }

    public static ServiceMessage21 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new ServiceMessage21(stream);
    }

    public static ServiceMessage21 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new ServiceMessage21(file);
    }

    public static ServiceMessage21 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new ServiceMessage21(fin);
    }

    public static MtId mtId() {
        return new MtId().setBusinessProcess("gpa").setMessageType("021");
    }

    @Override
    public String getMessageType() {
        return null;
    }

    public final boolean isAck() {
        return this.m.isAck();
    }

    public final boolean isNack() {
        return this.m.isNack();
    }

    public String getErrorCode() {
        Field405 f = this.getField405();
        if (f == null) {
            return null;
        }
        return f.getReasonForRejection();
    }

    public String getErrorLine() {
        Field405 f = this.getField405();
        if (f == null) {
            return null;
        }
        return f.getLineFieldNumber();
    }

    public Field177 getField177() {
        Tag t = this.tag("177");
        if (t != null) {
            return new Field177(t.getValue());
        }
        return null;
    }

    public Field451 getField451() {
        Tag t = this.tag("451");
        if (t != null) {
            return new Field451(t.getValue());
        }
        return null;
    }

    public Field405 getField405() {
        Tag t = this.tag("405");
        if (t != null) {
            return new Field405(t.getValue());
        }
        return null;
    }

    public Field108 getField108() {
        Tag t = this.tag("108");
        if (t != null) {
            return new Field108(t.getValue());
        }
        return null;
    }

    @Override
    public MtId getMtId() {
        return ServiceMessage21.mtId();
    }
}

