/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field116;
import com.prowidesoftware.swift.model.field.Field118;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT077
extends AbstractMT
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT077.class.getName());
    public static final String NAME = "077";

    public MT077(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT077(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT077 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT077(m);
    }

    public MT077() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT077(String sender, String receiver) {
        super(77, sender, receiver);
    }

    public MT077(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT077.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT077 object from FIN content with a Service Message. Check if the MT077 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT077 object from FIN content with message type " + param.getType());
        }
    }

    public static MT077 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT077(fin);
    }

    public MT077(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT077 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT077(stream);
    }

    public MT077(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT077 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT077(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT077 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT077 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT077 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT077 fromJson(String json) {
        return (MT077)AbstractMT.fromJson(json);
    }

    public Field116 getField116() {
        Tag t = this.tag("116");
        if (t != null) {
            return new Field116(t.getValue());
        }
        return null;
    }

    public Field118 getField118() {
        Tag t = this.tag("118");
        if (t != null) {
            return new Field118(t.getValue());
        }
        return null;
    }
}

