/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class PropertyLoader {
    private static final Logger log = Logger.getLogger(PropertyLoader.class.getName());
    static final String PROPERTIES_FILE = "pw-swift-core.properties";
    private static Properties properties = null;

    private PropertyLoader() {
    }

    static Properties loadProperties() {
        if (properties == null) {
            properties = new Properties();
            try (InputStream inputStream = PropertyLoader.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
                if (inputStream != null) {
                    properties.load(inputStream);
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Error loading properties from pw-swift-core.properties", e);
            }
        }
        return properties;
    }

    static String[] getPropertyArray(String key) {
        Properties loadedProperties = PropertyLoader.loadProperties();
        String propertyValue = loadedProperties.getProperty(key);
        if (propertyValue != null) {
            return propertyValue.split(",");
        }
        return new String[0];
    }

    static String getProperty(String key) {
        Properties loadedProperties = PropertyLoader.loadProperties();
        String propertyValue = loadedProperties.getProperty(key);
        if (propertyValue != null) {
            return propertyValue;
        }
        return null;
    }
}

