/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.utils.PropertyLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.ArrayUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SafeXmlUtils {
    private static final Logger log = Logger.getLogger(SafeXmlUtils.class.getName());
    private static final String FEATURE_IGNORE_PROPERTY = "safeXmlUtils.ignore";

    private SafeXmlUtils() {
        throw new AssertionError();
    }

    public static DocumentBuilder documentBuilder() {
        return SafeXmlUtils.documentBuilder(false);
    }

    public static DocumentBuilder documentBuilder(boolean namespaceAware) {
        String feature = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            feature = "http://javax.xml.XMLConstants/feature/secure-processing";
            if (SafeXmlUtils.applyFeature(feature)) {
                dbf.setFeature(feature, true);
            }
            if (SafeXmlUtils.applyFeature(feature = "http://xml.org/sax/features/external-general-entities")) {
                dbf.setFeature(feature, false);
            }
            if (SafeXmlUtils.applyFeature(feature = "http://apache.org/xml/features/disallow-doctype-decl")) {
                dbf.setFeature(feature, true);
            }
            dbf.setNamespaceAware(namespaceAware);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw SafeXmlUtils.logAndCreateException(e, feature, DocumentBuilderFactory.class.getName());
        }
    }

    public static XMLReader reader() throws ProwideException {
        return SafeXmlUtils.reader(false, null);
    }

    public static XMLReader reader(boolean namespaceAware, Schema schema) throws ProwideException {
        String feature = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            feature = "http://javax.xml.XMLConstants/feature/secure-processing";
            if (SafeXmlUtils.applyFeature(feature)) {
                spf.setFeature(feature, true);
            }
            if (SafeXmlUtils.applyFeature(feature = "http://xml.org/sax/features/external-general-entities")) {
                spf.setFeature(feature, false);
            }
            if (SafeXmlUtils.applyFeature(feature = "http://apache.org/xml/features/disallow-doctype-decl")) {
                spf.setFeature(feature, true);
            }
            spf.setNamespaceAware(namespaceAware);
            if (schema != null) {
                spf.setSchema(schema);
            }
            SAXParser saxParser = spf.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            if (SafeXmlUtils.applyFeature(feature)) {
                spf.setFeature(feature, true);
            }
            if (SafeXmlUtils.applyFeature(feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd")) {
                spf.setFeature(feature, false);
            }
            if (SafeXmlUtils.applyFeature(feature = "http://xml.org/sax/features/external-general-entities")) {
                spf.setFeature(feature, false);
            }
            if (SafeXmlUtils.applyFeature(feature = "http://xml.org/sax/features/external-parameter-entities")) {
                spf.setFeature(feature, false);
            }
            return reader;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw SafeXmlUtils.logAndCreateException(e, feature, SAXParserFactory.class.getName());
        }
    }

    public static XMLInputFactory inputFactory() {
        String property;
        XMLInputFactory xif = XMLInputFactory.newInstance();
        if (SafeXmlUtils.applyFeature("javax.xml.stream.supportDTD")) {
            xif.setProperty("javax.xml.stream.supportDTD", false);
        }
        if (SafeXmlUtils.applyFeature(property = "javax.xml.stream.isSupportingExternalEntities")) {
            xif.setProperty(property, false);
        }
        return xif;
    }

    public static Transformer transformer() {
        String feature = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            feature = "http://javax.xml.XMLConstants/property/accessExternalDTD";
            if (SafeXmlUtils.applyFeature(feature)) {
                tf.setAttribute(feature, "");
            }
            if (SafeXmlUtils.applyFeature(feature = "http://javax.xml.XMLConstants/property/accessExternalStylesheet")) {
                tf.setAttribute(feature, "");
            }
            return tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw SafeXmlUtils.logAndCreateException(e, feature, Transformer.class.getName());
        }
    }

    @Deprecated
    public static SchemaFactory schemaFactory() {
        String feature = null;
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            feature = "http://javax.xml.XMLConstants/property/accessExternalDTD";
            if (SafeXmlUtils.applyFeature(feature)) {
                factory.setProperty(feature, "");
            }
            return factory;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw SafeXmlUtils.logAndCreateException(e, feature, SchemaFactory.class.getName());
        }
    }

    @Deprecated
    public static Validator validator(Schema schema) {
        String feature = null;
        try {
            Validator validator = schema.newValidator();
            feature = "http://javax.xml.XMLConstants/property/accessExternalDTD";
            if (SafeXmlUtils.applyFeature(feature)) {
                validator.setProperty(feature, "");
            }
            if (SafeXmlUtils.applyFeature(feature = "http://javax.xml.XMLConstants/property/accessExternalSchema")) {
                validator.setProperty(feature, "");
            }
            return validator;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw SafeXmlUtils.logAndCreateException(e, feature, Validator.class.getName());
        }
    }

    private static boolean applyFeature(String feature) {
        Object[] prop = PropertyLoader.getPropertyArray(FEATURE_IGNORE_PROPERTY);
        return !ArrayUtils.contains((Object[])prop, (Object)feature);
    }

    private static ProwideException logAndCreateException(Exception e, String feature, String className) {
        log.log(Level.SEVERE, "Error configuring the " + className + ". The feature " + feature + " is not supported by your XML processor. Increase log level for details.");
        log.log(Level.FINER, "To avoid the missing feature, try removing the xerces and xalan dependencies in your project. If that is not doable, you can ignore this error by adding a pw-swift-core.properties in your application classpath with property safeXmlUtils.ignore=" + feature, e);
        return new ProwideException("Error configuring the " + className + ". The feature " + feature + " is not supported by your XML processor.", e);
    }
}

