/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.channel_groups;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.channel_group.PNChannelGroupsAddChannelResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0014J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0014J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/pubnub/api/endpoints/channel_groups/AddChannelChannelGroup;", "Lcom/pubnub/api/Endpoint;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/channel_group/PNChannelGroupsAddChannelResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channelGroup", "", "channels", "", "(Lcom/pubnub/api/PubNub;Ljava/lang/String;Ljava/util/List;)V", "getChannelGroup", "()Ljava/lang/String;", "getChannels", "()Ljava/util/List;", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNAddChannelsToGroupOperation;", "validateParams", "pubnub-kotlin"})
public final class AddChannelChannelGroup
extends Endpoint<Void, PNChannelGroupsAddChannelResult> {
    @NotNull
    private final String channelGroup;
    @NotNull
    private final List<String> channels;

    public AddChannelChannelGroup(@NotNull PubNub pubnub, @NotNull String channelGroup, @NotNull List<String> channels) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channelGroup, (String)"channelGroup");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        super(pubnub);
        this.channelGroup = channelGroup;
        this.channels = channels;
    }

    @NotNull
    public final String getChannelGroup() {
        return this.channelGroup;
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.listOf((Object)this.channelGroup);
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.channelGroup)) {
            throw new PubNubException(PubNubError.GROUP_MISSING);
        }
        if (this.channels.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getChannelGroupService$pubnub_kotlin().addChannelChannelGroup(this.getPubnub().getConfiguration().getSubscribeKey(), this.channelGroup, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNChannelGroupsAddChannelResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return new PNChannelGroupsAddChannelResult();
    }

    @Override
    @NotNull
    public PNOperationType.PNAddChannelsToGroupOperation operationType() {
        return PNOperationType.PNAddChannelsToGroupOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (!((Collection)this.channels).isEmpty()) {
            queryParams.put("add", PubNubUtilKt.toCsv(this.channels));
        }
    }
}

