/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.ParseTree;
import com.rabbitmq.jms.parse.sql.SqlToken;
import com.rabbitmq.jms.parse.sql.SqlTreeNode;
import java.util.ArrayList;

class SqlParseTree
implements ParseTree<SqlTreeNode> {
    private final SqlTreeNode node;
    private final SqlParseTree[] children;
    private final SqlTreeNode[] nodes;

    public SqlParseTree(SqlTreeNode node, SqlParseTree ... children) {
        this.node = node;
        this.children = children;
        this.nodes = SqlParseTree.genNodes(children);
    }

    @Override
    public SqlTreeNode getNode() {
        return this.node;
    }

    @Override
    public int getNumberOfChildren() {
        return this.children.length;
    }

    public SqlParseTree[] getChildren() {
        return this.children;
    }

    String[] formattedTree() {
        ArrayList<String> lines = new ArrayList<String>();
        SqlToken tokVal = this.node.value();
        lines.add(this.node.treeType().toString() + (tokVal == null ? ":" : ": " + tokVal));
        for (SqlParseTree child : this.children) {
            String[] childLines;
            for (String childLine : childLines = child.formattedTree()) {
                lines.add("    " + childLine);
            }
        }
        return lines.toArray(new String[lines.size()]);
    }

    public SqlTreeNode[] getChildNodes() {
        return this.nodes;
    }

    private static final SqlTreeNode[] genNodes(SqlParseTree[] children) {
        SqlTreeNode[] nodes = new SqlTreeNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            nodes[i] = children[i].getNode();
        }
        return nodes;
    }
}

