/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.convert;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.stereotype.Component;

@Component
@WritingConverter
public class LocalDateTimeToBytesConverter
implements Converter<LocalDateTime, byte[]> {
    byte[] fromString(String source) {
        return source.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] convert(LocalDateTime source) {
        Instant instant = source.atZone(ZoneId.systemDefault()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        return this.fromString(Long.toString(timeInMillis));
    }
}

