/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.tag;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;

public class ContainsAllPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final List<String> values;

    public ContainsAllPredicate(SearchFieldAccessor field, List<String> list) {
        super(field);
        this.values = list.stream().map(QueryUtils::escape).toList();
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public Node apply(Node root) {
        if (ObjectUtils.isEmpty(this.getValues())) {
            return root;
        }
        QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
        for (String value : this.getValues()) {
            and.add(this.getSearchAlias(), new String[]{"{" + value + "}"});
        }
        return QueryBuilders.intersect((Node[])new Node[]{root, and});
    }
}

