/*
 * Decompiled with CFR 0.152.
 */
package com.solace.transport.impl.netty;

import com.solace.transport.SolTransport;
import com.solace.transport.SolTransportBuilder;
import com.solace.transport.TransportConfiguration;
import com.solace.transport.TransportEventExceptionHandler;
import com.solace.transport.TransportExecutorService;
import com.solace.transport.TransportInboundFrameDecoder;
import com.solace.transport.impl.netty.NettySolTransport;
import com.solace.transport.impl.netty.NettySolWebSocketTransport;
import com.solace.transport.impl.netty.NettyTransportEventExceptionHandler;
import com.solace.transport.impl.netty.NettyTransportExecutorService;
import com.solace.transport.impl.netty.NettyTransportInboundFrameDecoderAdapter;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NettySolTransportBuilder
implements SolTransportBuilder {
    private static final String MISSING_ARGUMENT_ERROR = "%s must be provided to build a transport!";
    private TransportConfiguration transportConfiguration;
    private NettyTransportInboundFrameDecoderAdapter frameDecoder;
    private SolTransportBuilder.SocketReadabilityListener readabilityListener;
    private final NettyTransportEventExceptionHandler transportEventEmitter;
    private final NettyTransportExecutorService executorService;

    public NettySolTransportBuilder(TransportExecutorService executorService, TransportEventExceptionHandler handler, int connection_tag) {
        this.executorService = (NettyTransportExecutorService)executorService;
        this.transportEventEmitter = new NettyTransportEventExceptionHandler(handler, connection_tag);
    }

    @Override
    public SolTransport build() {
        if (this.transportConfiguration == null) {
            throw new IllegalArgumentException(String.format(MISSING_ARGUMENT_ERROR, "TransportConfiguration"));
        }
        if (this.frameDecoder == null) {
            throw new IllegalArgumentException(String.format(MISSING_ARGUMENT_ERROR, "TransportFrameDecoder"));
        }
        if (!this.transportConfiguration.isWebsocket()) {
            return new NettySolTransport(this.transportConfiguration, this.executorService, this.frameDecoder, this.transportEventEmitter);
        }
        return new NettySolWebSocketTransport(this.transportConfiguration, this.executorService, this.frameDecoder, this.transportEventEmitter);
    }

    @Override
    public SolTransportBuilder withFrameDecoder(TransportInboundFrameDecoder decoder) {
        this.frameDecoder = new NettyTransportInboundFrameDecoderAdapter(decoder, this.readabilityListener);
        return this;
    }

    @Override
    public <T> SolTransportBuilder withSocketReadabilityListener(SolTransportBuilder.SocketReadabilityListener readabilityListener) {
        this.readabilityListener = readabilityListener;
        return this;
    }

    @Override
    public SolTransportBuilder withConfiguration(TransportConfiguration options) {
        this.transportConfiguration = options;
        return this;
    }
}

