/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.latte.genids;

import com.sourceclear.analysis.latte.genids.Id;
import com.sourceclear.analysis.latte.parser.JavaScriptParser;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J$\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/sourceclear/analysis/latte/genids/VisitorUtils;", "", "()V", "toModuleRelative", "Lkotlin/Pair;", "", "Lcom/sourceclear/analysis/latte/genids/Id;", "projectRoot", "Ljava/nio/file/Path;", "id", "file", "unrollSingleExpressionToNames", "", "ctx", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$SingleExpressionContext;", "vulnerable-methods"})
public final class VisitorUtils {
    @NotNull
    public static final VisitorUtils INSTANCE = new VisitorUtils();

    private VisitorUtils() {
    }

    @NotNull
    public final List<String> unrollSingleExpressionToNames(@NotNull JavaScriptParser.SingleExpressionContext ctx) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        JavaScriptParser.SingleExpressionContext singleExpressionContext = ctx;
        if (singleExpressionContext instanceof JavaScriptParser.MemberDotExpressionContext) {
            Object object = ((JavaScriptParser.MemberDotExpressionContext)ctx).singleExpression();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.singleExpression()");
            List<String> prefix = this.unrollSingleExpressionToNames((JavaScriptParser.SingleExpressionContext)((Object)object));
            Collection collection = prefix;
            object = ((JavaScriptParser.MemberDotExpressionContext)ctx).identifierName().getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.identifierName().text");
            list = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOf((Object)object));
        } else if (singleExpressionContext instanceof JavaScriptParser.MemberIndexExpressionContext) {
            JavaScriptParser.SingleExpressionContext singleExpressionContext2 = ((JavaScriptParser.MemberIndexExpressionContext)ctx).singleExpression();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)singleExpressionContext2), (String)"ctx.singleExpression()");
            list = this.unrollSingleExpressionToNames(singleExpressionContext2);
        } else {
            list = singleExpressionContext instanceof JavaScriptParser.ThisExpressionContext ? CollectionsKt.listOf((Object)"this") : (singleExpressionContext instanceof JavaScriptParser.SuperExpressionContext ? CollectionsKt.listOf((Object)"super") : (singleExpressionContext instanceof JavaScriptParser.IdentifierExpressionContext ? CollectionsKt.listOf((Object)((JavaScriptParser.IdentifierExpressionContext)ctx).getText()) : (singleExpressionContext instanceof JavaScriptParser.ArgumentsExpressionContext ? CollectionsKt.listOf((Object)((JavaScriptParser.ArgumentsExpressionContext)ctx).getText()) : CollectionsKt.emptyList())));
        }
        return list;
    }

    @NotNull
    public final Pair<String, String> toModuleRelative(@NotNull Path projectRoot, @NotNull String file) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = Paths.get(file, new String[0]);
        if (!Intrinsics.areEqual((Object)path.toAbsolutePath().normalize(), (Object)path) || !StringsKt.startsWith$default((String)((Object)path.toAbsolutePath().normalize()).toString(), (String)((Object)projectRoot.toAbsolutePath().normalize()).toString(), (boolean)false, (int)2, null)) {
            return TuplesKt.to(null, (Object)file);
        }
        Path nodeModules = Paths.get("node_modules", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        Iterable $this$dropWhile$iv = path;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            Path it = (Path)item$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)nodeModules)) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        List suffix = list$iv;
        if (suffix.size() >= 2) {
            return TuplesKt.to((Object)suffix.get(1).toString(), (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)suffix, (int)2), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
        }
        try {
            pair = TuplesKt.to(null, (Object)((Object)projectRoot.relativize(path)).toString());
        }
        catch (IllegalArgumentException e) {
            pair = TuplesKt.to(null, (Object)file);
        }
        return pair;
    }

    @NotNull
    public final Pair<String, Id> toModuleRelative(@NotNull Path projectRoot, @NotNull Id id) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Pair<String, String> pair = this.toModuleRelative(projectRoot, id.getFilename());
        return TuplesKt.to((Object)pair.getFirst(), (Object)Id.copy$default(id, (String)pair.getSecond(), null, 2, null));
    }
}

