/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.git;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class GitCommit
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String commitHash;
    private final String authorName;
    private final String authorEmail;
    private final Date commitDate;

    @JsonCreator
    public GitCommit(@JsonProperty(value="commitHash") @NonNull String commitHash, @JsonProperty(value="authorName") @NonNull String authorName, @JsonProperty(value="authorEmail") @NonNull String authorEmail, @JsonProperty(value="commitDate") @NonNull Date commitDate) {
        Objects.requireNonNull(commitHash, "GitCommit requires a non-null \"commitHash\"");
        Objects.requireNonNull(authorName, "GitCommit requires a non-null \"authorName\"");
        Objects.requireNonNull(authorEmail, "GitCommit requires a non-null \"authorEmail\"");
        Objects.requireNonNull(commitDate, "GitCommit requires a non-null \"commitDate\"");
        this.commitHash = commitHash;
        this.authorName = authorName;
        this.authorEmail = authorEmail;
        this.commitDate = commitDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitCommit gitCommit = (GitCommit)o;
        return this.getCommitHash().equals(gitCommit.getCommitHash()) && this.getAuthorName().equals(gitCommit.getAuthorName()) && this.getAuthorEmail().equals(gitCommit.getAuthorEmail()) && this.getCommitDate().equals(gitCommit.getCommitDate());
    }

    public int hashCode() {
        return Objects.hash(this.getCommitHash(), this.getAuthorName(), this.getAuthorEmail(), this.getCommitDate());
    }

    @Nonnull
    public String getCommitHash() {
        return this.commitHash;
    }

    @Nonnull
    public String getAuthorName() {
        return this.authorName;
    }

    @Nonnull
    public String getAuthorEmail() {
        return this.authorEmail;
    }

    @Nonnull
    public Date getCommitDate() {
        return this.commitDate;
    }
}

