/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.sourceclear.bytecode.ClassFingerprint;
import com.sourceclear.bytecode.HashedMethodFingerprint;
import com.sourceclear.bytecode.Util;
import java.io.Serializable;
import java.util.ArrayList;

public class HashedClassFingerprint
implements Serializable {
    private final ImmutableSortedMap<Integer, HashedMethodFingerprint> methodsMap;
    private final ImmutableSortedSet<Integer> fieldsSet;
    private final ImmutableSortedSet<Integer> calledMethodsSet;
    private final ImmutableSortedSet<Integer> importsSet;
    private final byte[] hash;

    public HashedClassFingerprint(ImmutableSortedMap<Integer, HashedMethodFingerprint> methodsMap, ImmutableSortedSet<Integer> fieldsSet, ImmutableSortedSet<Integer> calledMethodsSet, ImmutableSortedSet<Integer> importsSet) {
        this.methodsMap = methodsMap;
        this.fieldsSet = fieldsSet;
        this.calledMethodsSet = calledMethodsSet;
        this.importsSet = importsSet;
        ArrayList bytes = Lists.newArrayList();
        for (Integer i : methodsMap.keySet()) {
            bytes.add(Ints.toByteArray((int)i));
        }
        for (HashedMethodFingerprint p : methodsMap.values()) {
            bytes.add(p.getHash());
        }
        bytes.add(Util.hashInts(fieldsSet));
        bytes.add(Util.hashInts(calledMethodsSet));
        bytes.add(Util.hashInts(importsSet));
        this.hash = Util.hashBytes(bytes);
    }

    public HashedClassFingerprint(ClassFingerprint cfp) {
        this(Util.immutableMapStringtoimmmutableSortedMapInt(cfp.getMethodsMap()), Util.immutableSetStringtoImmutableSortedSetInt(cfp.getFieldsSet()), Util.immutableSetStringtoImmutableSortedSetInt(cfp.getCalledMethodsSet()), Util.immutableSetStringtoImmutableSortedSetInt(cfp.getImportsSet()));
    }

    public ImmutableMap<Integer, HashedMethodFingerprint> getMethodsMap() {
        return this.methodsMap;
    }

    public ImmutableSet<Integer> getFieldsSet() {
        return this.fieldsSet;
    }

    public ImmutableSet<Integer> getCalledMethodsSet() {
        return this.calledMethodsSet;
    }

    public ImmutableSet<Integer> getImportsSet() {
        return this.importsSet;
    }

    public byte[] getHash() {
        return this.hash;
    }
}

