/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode.v2;

import com.sourceclear.bytecode.InputStreamGenerator;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class ClassFingerprint {
    private byte[] cachedHash;

    public ClassFingerprint(InputStreamGenerator streamGenerator) throws IOException {
        this.computeHashInternally(streamGenerator);
    }

    public byte[] hash() {
        return Arrays.copyOf(this.cachedHash, this.cachedHash.length);
    }

    private void computeHashInternally(InputStreamGenerator streamGenerator) throws IOException {
        byte[] bytes = new byte[1024];
        try (DigestInputStream sha1Stream = new DigestInputStream(streamGenerator.getInputStream(), MessageDigest.getInstance("SHA-1"));){
            while (sha1Stream.read(bytes) != -1) {
            }
            this.cachedHash = sha1Stream.getMessageDigest().digest();
            return;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("SHA1 algorithm is not supported by the runtime");
        }
    }
}

